<?php add_action('admin_init', 'add_meta_boxes', 1);
function add_meta_boxes() {
	global $post;
	$post_id = '';
	if(isset($_GET['post'])){
		$post_id = $_GET['post'] ? $_GET['post'] : $_POST['post_ID'] ;
	}
	$template_file = get_post_meta($post_id,'_wp_page_template',TRUE);
	add_meta_box( 'ale_links_details', 'Additional Details', 'ale_links_details_box_display', 'events', 'normal', 'high');
}

function ale_links_details_box_display() {
global $post;

$ale_links_details = get_post_meta($post->ID, 'ale_links_details', true);


wp_nonce_field( 'ale_links_details_box_nonce', 'ale_links_details_box_nonce' );
?>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('.links-metabox_submit').click(function(e) {
			e.preventDefault();
			$('#publish').click();
		});
		$('#links-add-row').on('click', function() {
			var row = $('.links-empty-row.links-screen-reader-text').clone(true);
			row.removeClass('links-empty-row links-screen-reader-text');
			row.insertBefore('#links-repeatable-fieldset-one tbody>tr:last');
			return false;
		});
		$('.links-remove-row').on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});

		$('#links-repeatable-fieldset-one tbody').sortable({
			opacity: 0.6,
			revert: true,
			cursor: 'move',
			handle: '.sort'
		});
	});
</script>

<table id="links-repeatable-fieldset-one" width="100%">
	<thead>
	<tr>
		<th width="2%"></th>
		<th width="30%"><?php _e('Link', 'aletheme'); ?></th>
		<th width="60%"><?php _e('Text for the link', 'aletheme'); ?></th>
		<th width="2%"></th>
	</tr>
	</thead>
	<tbody>
	<?php

	if ( $ale_links_details ) :

		foreach ( $ale_links_details as $field ) {
			?>
			<tr>
				<td><a class="button links-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
				<td><input type="text" class="widefat" name="url[]" value="<?php if($field['url'] != '') echo esc_attr( $field['url'] ); ?>" /></td>

				<td><input type="text" class="widefat" name="text[]" value="<?php if ($field['text'] != '') echo esc_attr( $field['text'] );  ?>" /></td>
				<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

			</tr>
		<?php
		}
	else :
		// show a blank one
		?>
		<tr>
			<td><a class="button links-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
			<td><input type="text" class="widefat" name="url[]" /></td>


			<td><input type="text" class="widefat" name="text[]" value="" /></td>
			<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

		</tr>
	<?php endif; ?>

	<!-- empty hidden one for jQuery -->
	<tr class="links-empty-row links-screen-reader-text">
		<td><a class="button links-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
		<td><input type="text" class="widefat" name="url[]" /></td>


		<td><input type="text" class="widefat" name="text[]" value="" /></td>
		<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

	</tr>
	</tbody>
</table>

<p><a id="links-add-row" class="button" href="#"><span class="dashicons dashicons-plus" style="line-height: 28px; font-size:14px;"></span> Add another</a>
	<input type="submit" class="links-metabox_submit" value="Save" />
</p>

<?php
}

add_action('save_post', 'ale_links_details_box_save');
function ale_links_details_box_save($post_id) {
	if ( ! isset( $_POST['ale_links_details_box_nonce'] ) ||
		! wp_verify_nonce( $_POST['ale_links_details_box_nonce'], 'ale_links_details_box_nonce' ) )
		return;

	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
		return;

	if (!current_user_can('edit_post', $post_id))
		return;

	$old = get_post_meta($post_id, 'ale_links_details', true);
	$new = array();


	$url = $_POST['url'];
	$text = $_POST['text'];

	$count = count( $url );

	for ( $i = 0; $i < $count; $i++ ) {
		if ( $url[$i] != '' ) :
			$new[$i]['url'] = stripslashes( strip_tags( $url[$i] ) );
			$new[$i]['text'] = stripslashes( $text[$i] );
		endif;
	}

	if ( !empty( $new ) && $new != $old )
		update_post_meta( $post_id, 'ale_links_details', $new );
	elseif ( empty($new) && $old )
		delete_post_meta( $post_id, 'ale_links_details', $old );
}