<?php add_action('admin_init', 'add_history_meta_boxes', 2);
function add_history_meta_boxes() {
	global $post;
	$post_id = '';
	if(isset($_GET['post'])){
		$post_id = $_GET['post'] ? $_GET['post'] : $_POST['post_ID'] ;
	}
	$template_file = get_post_meta($post_id,'_wp_page_template',TRUE);
	if ($template_file == 'template-home-4.php') {
		add_meta_box( 'ale_history_details', 'History', 'ale_history_details_box_display', 'page', 'normal', 'high');
	}
}

function ale_history_details_box_display() {
global $post;

$ale_history_details = get_post_meta($post->ID, 'ale_history_details', true);


wp_nonce_field( 'ale_history_details_box_nonce', 'ale_history_details_box_nonce' );
?>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('.history-metabox_submit').click(function(e) {
			e.preventDefault();
			$('#publish').click();
		});
		$('#history-add-row').on('click', function() {
			var row = $('.history-empty-row.history-screen-reader-text').clone(true);
			row.removeClass('history-empty-row history-screen-reader-text');
			row.insertBefore('#history-repeatable-fieldset-one tbody>tr:last');
			return false;
		});
		$('.history-remove-row').on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});

		$('#history-repeatable-fieldset-one tbody').sortable({
			opacity: 0.6,
			revert: true,
			cursor: 'move',
			handle: '.sort'
		});
	});
</script>

<table id="history-repeatable-fieldset-one" width="100%">
	<thead>
		<tr>
			<th width="2%"></th>
			<th width="10%"><?php _e('Date', 'aletheme'); ?></th>
			<th width="36%"><?php _e('Title', 'aletheme'); ?></th>
			<th width="50%"><?php _e('Text', 'aletheme'); ?></th>
			<th width="2%"></th>
		</tr>
	</thead>
	<tbody>
	<?php

	if ( $ale_history_details ) :

		foreach ( $ale_history_details as $field ) {
			?>
			<tr>
				<td><a class="button history-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
				<td><input type="text" class="widefat" name="date[]" value="<?php if($field['date'] != '') echo esc_attr( $field['date'] ); ?>" /></td>
				<td><input type="text" class="widefat" name="title[]" value="<?php if ($field['title'] != '') echo esc_attr( $field['title'] );  ?>" /></td>
				<td><input type="text" class="widefat" name="text[]" value="<?php if($field['text'] != '') echo esc_attr( $field['text'] ); ?>" /></td>
				<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>
			</tr>
		<?php
		}
	else :
		// show a blank one
		?>
		<tr>
			<td><a class="button history-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
			<td><input type="text" class="widefat" name="date[]" /></td>
			<td><input type="text" class="widefat" name="title[]" value="" /></td>
			<td><input type="text" class="widefat" name="text[]" value="" /></td>
			<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>
		</tr>
	<?php endif; ?>

	<!-- empty hidden one for jQuery -->
	<tr class="history-empty-row history-screen-reader-text">
		<td><a class="button history-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
		<td><input type="text" class="widefat" name="date[]" /></td>
		<td><input type="text" class="widefat" name="title[]" value="" /></td>
		<td><input type="text" class="widefat" name="text[]" value="" /></td>
		<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>
	</tr>
	</tbody>
</table>

<p><a id="history-add-row" class="button" href="#"><span class="dashicons dashicons-plus" style="line-height: 28px; font-size:14px;"></span> Add another</a>
	<input type="submit" class="history-metabox_submit" value="Save" />
</p>

<?php
}

add_action('save_post', 'ale_history_details_box_save');
function ale_history_details_box_save($post_id) {
	if ( ! isset( $_POST['ale_history_details_box_nonce'] ) ||
		! wp_verify_nonce( $_POST['ale_history_details_box_nonce'], 'ale_history_details_box_nonce' ) )
		return;

	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
		return;

	if (!current_user_can('edit_post', $post_id))
		return;

	$old = get_post_meta($post_id, 'ale_history_details', true);
	$new = array();


	$date = $_POST['date'];
	$title = $_POST['title'];
	$text = $_POST['text'];

	$count = count( $date );

	for ( $i = 0; $i < $count; $i++ ) {
		if ( $date[$i] != '' ) :
			$new[$i]['date'] = stripslashes( strip_tags( $date[$i] ) );
			$new[$i]['title'] = stripslashes( $title[$i] );
			$new[$i]['text'] = stripslashes( $text[$i] );
		endif;
	}

	if ( !empty( $new ) && $new != $old )
		update_post_meta( $post_id, 'ale_history_details', $new );
	elseif ( empty($new) && $old )
		delete_post_meta( $post_id, 'ale_history_details', $old );
}