<?php add_action('admin_init', 'add_academic_table_meta_boxes', 2);
function add_academic_table_meta_boxes() {
	global $post;
	$post_id = '';
	if(isset($_GET['post'])){
		$post_id = $_GET['post'] ? $_GET['post'] : $_POST['post_ID'] ;
	}
	$template_file = get_post_meta($post_id,'_wp_page_template',TRUE);
	add_meta_box( 'ale_academic_table_details', 'Table', 'ale_academic_table_details_box_display', 'academics', 'normal', 'high');

}

function ale_academic_table_details_box_display() {
global $post;

$ale_academic_table_details = get_post_meta($post->ID, 'ale_academic_table_details', true);


wp_nonce_field( 'ale_academic_table_details_box_nonce', 'ale_academic_table_details_box_nonce' );
?>
<script type="text/javascript">
	jQuery(document).ready(function($) {
		$('.academic-table-metabox_submit').click(function(e) {
			e.preventDefault();
			$('#publish').click();
		});
		$('#academic-table-add-row').on('click', function() {
			var row = $('.academic-table-empty-row.academic-table-screen-reader-text').clone(true);
			row.removeClass('academic-table-empty-row academic-table-screen-reader-text');
			row.insertBefore('#academic-table-repeatable-fieldset-one tbody>tr:last');
			return false;
		});
		$('.academic-table-remove-row').on('click', function() {
			$(this).parents('tr').remove();
			return false;
		});

		$('#academic-table-repeatable-fieldset-one tbody').sortable({
			opacity: 0.6,
			revert: true,
			cursor: 'move',
			handle: '.sort'
		});
	});
</script>

<table id="academic-table-repeatable-fieldset-one" width="100%">
	<thead>
		<tr>
			<th width="2%"></th>
			<th width="11%"><?php _e('Year', 'aletheme'); ?></th>
			<th width="17%"><?php _e('Monday', 'aletheme'); ?></th>
			<th width="17%"><?php _e('Tuesday', 'aletheme'); ?></th>
			<th width="17%"><?php _e('Wednesday', 'aletheme'); ?></th>
			<th width="17%"><?php _e('Thursday', 'aletheme'); ?></th>
			<th width="17%"><?php _e('Friday', 'aletheme'); ?></th>
			<th width="2%"></th>
		</tr>
	</thead>
	<tbody>
	<?php

	if ( $ale_academic_table_details ) :

		foreach ( $ale_academic_table_details as $field ) {
			?>
			<tr>
				<td><a class="button academic-table-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
				<td><input type="text" class="widefat" name="year[]" value="<?php if($field['year'] != '') echo esc_attr( $field['year'] ); ?>" /></td>
				<td><input type="text" class="widefat" name="monday[]" value="<?php if ($field['monday'] != '') echo esc_attr( $field['monday'] );  ?>" /></td>
				<td><input type="text" class="widefat" name="tuesday[]" value="<?php if($field['tuesday'] != '') echo esc_attr( $field['tuesday'] ); ?>" /></td>
				<td><input type="text" class="widefat" name="wednesday[]" value="<?php if($field['wednesday'] != '') echo esc_attr( $field['wednesday'] ); ?>" /></td>
				<td><input type="text" class="widefat" name="thursday[]" value="<?php if($field['thursday'] != '') echo esc_attr( $field['thursday'] ); ?>" /></td>
				<td><input type="text" class="widefat" name="friday[]" value="<?php if($field['friday'] != '') echo esc_attr( $field['friday'] ); ?>" /></td>
				<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>
			</tr>
		<?php
		}
	else :
		// show a blank one
		?>
		<tr>
			<td><a class="button academic-table-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
			<td><input type="text" class="widefat" name="year[]" /></td>
			<td><input type="text" class="widefat" name="monday[]" value="" /></td>
			<td><input type="text" class="widefat" name="tuesday[]" value="" /></td>
			<td><input type="text" class="widefat" name="wednesday[]" value="" /></td>
			<td><input type="text" class="widefat" name="thursday[]" value="" /></td>
			<td><input type="text" class="widefat" name="friday[]" value="" /></td>
			<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>
		</tr>
	<?php endif; ?>

	<!-- empty hidden one for jQuery -->
	<tr class="academic-table-empty-row academic-table-screen-reader-text">
		<td><a class="button academic-table-remove-row" href="#"><span class="dashicons dashicons-trash"></span></a></td>
		<td><input type="text" class="widefat" name="year[]" /></td>
		<td><input type="text" class="widefat" name="monday[]" value="" /></td>
		<td><input type="text" class="widefat" name="tuesday[]" value="" /></td>
		<td><input type="text" class="widefat" name="wednesday[]" value="" /></td>
		<td><input type="text" class="widefat" name="thursday[]" value="" /></td>
		<td><input type="text" class="widefat" name="friday[]" value="" /></td>
		<td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>
	</tr>
	</tbody>
</table>

<p><a id="academic-table-add-row" class="button" href="#"><span class="dashicons dashicons-plus" style="line-height: 28px; font-size:14px;"></span> Add another</a>
	<input type="submit" class="academic-table-metabox_submit" value="Save" />
</p>

<?php
}

add_action('save_post', 'ale_academic_table_details_box_save');
function ale_academic_table_details_box_save($post_id) {
	if ( ! isset( $_POST['ale_academic_table_details_box_nonce'] ) ||
		! wp_verify_nonce( $_POST['ale_academic_table_details_box_nonce'], 'ale_academic_table_details_box_nonce' ) )
		return;

	if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
		return;

	if (!current_user_can('edit_post', $post_id))
		return;

	$old = get_post_meta($post_id, 'ale_academic_table_details', true);
	$new = array();


	$year = $_POST['year'];
	$monday = $_POST['monday'];
	$tuesday = $_POST['tuesday'];
	$wednesday = $_POST['wednesday'];
	$thursday = $_POST['thursday'];
	$friday = $_POST['friday'];

	$count = count( $year );

	for ( $i = 0; $i < $count; $i++ ) {
		if ( $year[$i] != '' ) :
			$new[$i]['year'] = stripslashes( strip_tags( $year[$i] ) );
			$new[$i]['monday'] = stripslashes( $monday[$i] );
			$new[$i]['tuesday'] = stripslashes( $tuesday[$i] );
			$new[$i]['wednesday'] = stripslashes( $wednesday[$i] );
			$new[$i]['thursday'] = stripslashes( $thursday[$i] );
			$new[$i]['friday'] = stripslashes( $friday[$i] );
		endif;
	}

	if ( !empty( $new ) && $new != $old )
		update_post_meta( $post_id, 'ale_academic_table_details', $new );
	elseif ( empty($new) && $old )
		delete_post_meta( $post_id, 'ale_academic_table_details', $old );
}