<?php
/**
 * Get current theme options
 * 
 * @return array
 */
function aletheme_get_options() {
	$comments_style = array(
		'wp'  => 'Alethemes Comments',
		'fb'  => 'Facebook Comments',
		'dq'  => 'DISQUS',
		'lf'  => 'Livefyre',
		'off' => 'Disable All Comments',
	);

	$analytics = array(
		'classic'  => 'Classic Analytics',
		'universal'  => 'Universal Analytics',
	);

	$headerfont = array_merge(ale_get_safe_webfonts(), ale_get_google_webfonts());

	$background_defaults = array(
		'color' => '#ffffff',
		'image' => '',
		'repeat' => 'repeat',
		'position' => 'top center',
		'attachment'=>'scroll'
	);

	//Footer
	$footer_type = array(
		'default'  => 'Default',
		'widget'  => 'Widget',
	);
	
	$imagepath =  ALETHEME_URL . '/assets/images/';
	
	$options = array();
		
	$options[] = array("name" => "Theme",
						"type" => "heading");

	$options[] = array( "name" => "Header Logo",
						"desc" => "Upload or put the header logo link (Default logo size: 201x69px)",
						"id" => "ale_headerlogo",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Footer Logo",
						"desc" => "Upload or put the footer logo link (Default logo size: 134x46px)",
						"id" => "ale_footerlogo",
						"std" => "",
						"type" => "upload");

	$options[] = array( 'name' => "Manage Background",
						'desc' => "Select the background color, or upload a custom background image. Default background is the #f5f5f5 color",
						'id' => 'ale_background',
						'std' => $background_defaults,
						'type' => 'background');

	$options[] = array( "name" => "Background Size Cover",
						"desc" => "Check if you want to select cover background size",
						"id" => "ale_backcover",
						"std" => "1",
						"type" => "checkbox");

	$options[] = array( 'name' => "Manage Main Color (Dark)",
						'desc' => "Select the color. Default color is the #3b2409 color",
						'id' => 'ale_maincolordark',
						'std' => '#3b2409',
						'type' => 'color');

	$options[] = array( 'name' => "Manage Main Color (Medium)",
						'desc' => "Select the color. Default color is the #8d7a65 color",
						'id' => 'ale_maincolormedium',
						'std' => '#8d7a65',
						'type' => 'color');

	$options[] = array( 'name' => "Manage Main Color (Light)",
						'desc' => "Select the color. Default color is the #afa293 color",
						'id' => 'ale_maincolorlight',
						'std' => '#afa293',
						'type' => 'color');

	$options[] = array( 'name' => "Manage Secondary Color (Dark)",
						'desc' => "Select the color. Default color is the #f0a900 color",
						'id' => 'ale_secondarycolordark',
						'std' => '#f0a900',
						'type' => 'color');

	$options[] = array( 'name' => "Manage Secondary Color (Light)",
						'desc' => "Select the color. Default color is the #f7be1a color",
						'id' => 'ale_secondarycolorlight',
						'std' => '#f7be1a',
						'type' => 'color');

	$options[] = array( "name" => "Uplaod a favicon icon",
						"desc" => "Upload or put the link of your favicon icon",
						"id" => "ale_favicon",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Comments Style",
						"desc" => "Choose your comments style. If you want to use DISQUS comments please install and activate this plugin from <a href=\"" . admin_url('plugin-install.php?tab=search&type=term&s=Disqus+Comment+System&plugin-search-input=Search+Plugins') . "\">Wordpress Repository</a>.  If you want to use Livefyre Realtime Comments comments please install and activate this plugin from <a href=\"" . admin_url('plugin-install.php?tab=search&type=term&s=Livefyre+Realtime+Comments&plugin-search-input=Search+Plugins') . "\">Wordpress Repository</a>.",
						"id" => "ale_comments_style",
						"std" => "wp",
						"type" => "select",
						"options" => $comments_style);

	$options[] = array( "name" => "AJAX Comments",
						"desc" => "Use AJAX on comments posting (works only with Alethemes Comments selected).",
						"id" => "ale_ajax_comments",
						"std" => "1",
						"type" => "checkbox");

	$options[] = array( "name" => "Social Sharing",
						"desc" => "Enable social sharing for posts.",
						"id" => "ale_social_sharing",
						"std" => "1",
						"type" => "checkbox");

	$options[] = array( "name" => "Copyrights",
						"desc" => "Your copyright message.",
						"id" => "ale_copyrights",
						"std" => "",
						"type" => "editor");

	$options[] = array( "name" => "Home Page Slider slug",
						"desc" => "Insert the slider slug. Get the slug on Sliders Section",
						"id" => "ale_homeslugfull",
						"std" => "",
						"type" => "text");

	$options[] = array( "name" => "Typography",
						"type" => "heading");


	$options[] = array( "name" => "Select the Header Font from Google Library",
						"desc" => "The default Font is - Arimo",
						"id" => "ale_headerfont",
						"std" => "Arimo",
						"type" => "select",
						"options" => $headerfont);

	$options[] = array( "name" => "Select the Header Font (Extended) from Google Library",
						"desc" => "The default Font (extended) is - 400, 700",
						"id" => "ale_headerfontex",
						"std" => "400,700",
						"type" => "text",
						);


	$options[] = array( "name" => "Select the Title Font from Google Library",
						"desc" => "The default Font is - PT Serif",
						"id" => "ale_titlefont",
						"std" => "PT+Serif",
						"type" => "select",
						"options" => $headerfont);

	$options[] = array( "name" => "Select the Title Font (Extended) from Google Library",
						"desc" => "The default Font (extended) is - 400, 700",
						"id" => "ale_titlefontex",
						"std" => "400,700",
						"type" => "text",
						);


	$options[] = array( "name" => "Select the Button Font from Google Library",
						"desc" => "The default Font is - PT Sans",
						"id" => "ale_buttonfont",
						"std" => "PT+Sans",
						"type" => "select",
						"options" => $headerfont);

	$options[] = array( "name" => "Select the Button Font (Extended) from Google Library",
						"desc" => "The default Font (extended) is - 400, 700",
						"id" => "ale_buttonfontex",
						"std" => "400,700",
						"type" => "text",
						);


	$options[] = array( "name" => "Select the Testimonials Font from Google Library",
						"desc" => "The default Font is - Open Sans",
						"id" => "ale_testimonialsfont",
						"std" => "Open+Sans",
						"type" => "select",
						"options" => $headerfont);

	$options[] = array( "name" => "Select the Testimonials Font (Extended) from Google Library",
						"desc" => "The default Font (extended) is - 400, 700",
						"id" => "ale_testimonialsfontex",
						"std" => "400,700",
						"type" => "text",
						);



	$options[] = array( 'name' => "H1 Style",
						'desc' => "Change the h1 style",
						'id' => 'ale_h1sty',
						'std' => array('size' => '22px','face' => 'PT+Serif','style' => 'normal','color' => '#2f251a'),
						'type' => 'typography');

	$options[] = array( 'name' => "H2 Style",
						'desc' => "Change the h2 style",
						'id' => 'ale_h2sty',
						'std' => array('size' => '20px','face' => 'PT+Serif','style' => 'normal','color' => '#2f251a'),
						'type' => 'typography');

	$options[] = array( 'name' => "H3 Style",
						'desc' => "Change the h3 style",
						'id' => 'ale_h3sty',
						'std' => array('size' => '18px','face' => 'PT+Serif','style' => 'normal','color' => '#2f251a'),
						'type' => 'typography');

	$options[] = array( 'name' => "H4 Style",
						'desc' => "Change the h4 style",
						'id' => 'ale_h4sty',
						'std' => array('size' => '16px','face' => 'PT+Serif','style' => 'normal','color' => '#2f251a'),
						'type' => 'typography');

	$options[] = array( 'name' => "H5 Style",
						'desc' => "Change the h5 style",
						'id' => 'ale_h5sty',
						'std' => array('size' => '14px','face' => 'PT+Serif','style' => 'normal','color' => '#2f251a'),
						'type' => 'typography');

	$options[] = array( 'name' => "H6 Style",
						'desc' => "Change the h6 style",
						'id' => 'ale_h6sty',
						'std' => array('size' => '12px','face' => 'PT+Serif','style' => 'normal','color' => '#2f251a'),
						'type' => 'typography');

	$options[] = array( 'name' => "Body Style",
						'desc' => "Change the body font style",
						'id' => 'ale_bodystyle',
						'std' => array('size' => '12px','face' => 'PT+Serif','style' => 'normal','color' => '#2f251a'),
						'type' => 'typography');

	$options[] = array( "name" => "Social",
						"type" => "heading");

	$options[] = array( "name" => "Google+",
						"desc" => "Your google+ profile URL.",
						"id" => "ale_gog",
						"std" => "https://plus.google.com/",
						"type" => "text");

	$options[] = array( "name" => "Skype",
						"desc" => "Your skype profile URL.",
						"id" => "ale_sky",
						"std" => "http://www.skype.com/",
						"type" => "text");

	$options[] = array( "name" => "Facebook",
						"desc" => "Your facebook profile URL.",
						"id" => "ale_fb",
						"std" => "https://www.facebook.com/",
						"type" => "text");

	$options[] = array( "name" => "Linkedin",
						"desc" => "Your linkedin profile URL.",
						"id" => "ale_linkedin",
						"std" => "https://www.linkedin.com/",
						"type" => "text");

	$options[] = array( "name" => "Twitter",
						"desc" => "Insert the login name",
						"id" => "ale_twiname",
						"std" => "",
						"type" => "text");

	
	$options[] = array( "name" => "Facebook Application ID",
						"desc" => "If you have Application ID you can connect the blog to your Facebook Profile and monitor statistics there.",
						"id" => "ale_fb_id",
						"std" => "",
						"type" => "text");
	
	$options[] = array( "name" => "Enable Open Graph",
						"desc" => "The <a href=\"http://www.ogp.me/\">Open Graph</a> protocol enables any web page to become a rich object in a social graph.",
						"id" => "ale_og_enabled",
						"std" => "",
						"type" => "checkbox");


	
	$options[] = array( "name" => "Advanced Settings",
						"type" => "heading");

	$options[] = array( "name" => "Google Analytics Type",
						"desc" => "Select the google analytics code type. Universal or Classic (The difference between versions you will find in google)",
						"id" => "ale_analyticstype",
						"std" => "classic",
						"type" => "select",
						"options" => $analytics);
	
	$options[] = array( "name" => "Google Analytics",
						"desc" => "Please insert your Google Analytics code here. Example: <strong>UA-22231623-1</strong>",
						"id" => "ale_ga",
						"std" => "",
						"type" => "text");
	
	$options[] = array( "name" => "Footer Code",
						"desc" => "If you have anything else to add in the footer - please add it here.",
						"id" => "ale_footer_info",
						"std" => "",
						"type" => "textarea");

	$options[] = array( "name" => "Custom CSS Styles",
						"desc" => "You can add here your styles. ex. .boxclass { padding:10px; }",
						"id" => "ale_customcsscode",
						"std" => "",
						"type" => "textarea");

	$options[] = array( "name" => "Enable Preloader",
						"desc" => "Check this option to enable the animated pre loader",
						"id" => "ale_preloader",
						"std" => "",
						"type" => "checkbox");

	$options[] = array( "name" => "Enable Style Selector",
						"desc" => "Check this option to enable the style selector box",
						"id" => "ale_colorselector",
						"std" => "",
						"type" => "checkbox");

	$options[] = array( "name" => "GEO IP Location",
						"desc" => "Check this option to enable the GEO IP Location in the Header",
						"id" => "ale_geoip",
						"std" => "",
						"type" => "checkbox");

	$options[] = array( "name" => "Header",
						"type" => "heading");

	$options[] = array( "name" => "Phone",
						"desc" => "Insert your phone number",
						"id" => "ale_headernum",
						"std" => "1800-562-3764",
						"type" => "text");

	$options[] = array( "name" => "Email",
						"desc" => "Insert your email address",
						"id" => "ale_headeremail",
						"std" => "enquiries@website.com",
						"type" => "text");

	$options[] = array( "name" => "Footer",
						"type" => "heading");

	$options[] = array( "name" => "Footer Type",
						"desc" => "Select the footer type",
						"id" => "ale_footer_type",
						"std" => "default",
						"type" => "select",
						"options" => $footer_type);

	$options[] = array( "name" => "Text",
						"desc" => "Insert the text",
						"id" => "ale_footertext",
						"std" => "Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue.",
						"type" => "text");

	$options[] = array( "name" => "Link No. 1",
						"desc" => "Insert the Url",
						"id" => "ale_footerurl1",
						"std" => "https://www.google.com",
						"type" => "text");

	$options[] = array( "name" => "Link for text No. 1",
						"desc" => "Insert the Text",
						"id" => "ale_footerurltext1",
						"std" => "Expert teachers",
						"type" => "text");

	$options[] = array( "name" => "Link No. 2",
						"desc" => "Insert the Url",
						"id" => "ale_footerurl2",
						"std" => "https://www.google.com",
						"type" => "text");

	$options[] = array( "name" => "Link for text No. 2",
						"desc" => "Insert the Text",
						"id" => "ale_footerurltext2",
						"std" => "Library",
						"type" => "text");

	$options[] = array( "name" => "Recent blog Title",
						"desc" => "Insert the title",
						"id" => "ale_footerrecentblogtitle",
						"std" => "Recent blog",
						"type" => "text");

	$options[] = array( "name" => "Instagram feed Title",
						"desc" => "Insert the title",
						"id" => "ale_footerinstagramfeedtitle",
						"std" => "Instagram feed",
						"type" => "text");

	$options[] = array( "name" => "Instagram Logo",
						"desc" => "Upload an image. Size: 86x86px",
						"id" => "ale_footerinstagramfeedlogo",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Google+",
						"desc" => "Insert the URL",
						"id" => "ale_footerinstagramfeedgoogle",
						"std" => "https://www.google.com",
						"type" => "text");

	$options[] = array( "name" => "Twitter",
						"desc" => "Insert the URL",
						"id" => "ale_footerinstagramfeedtwi",
						"std" => "https://twitter.com",
						"type" => "text");

	$options[] = array( "name" => "Facebook",
						"desc" => "Insert the URL",
						"id" => "ale_footerinstagramfeedface",
						"std" => "https://www.facebook.com",
						"type" => "text");

	$options[] = array( "name" => "Featured image",
						"type" => "heading");

	$options[] = array( "name" => "Blog",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimageblog",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Course",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagecourse",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Events",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimageevents",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Gallery",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagegallery",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "News",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagenews",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Academics",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimageacademics",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "About",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimageabout",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Admission",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimageadmission",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Contact",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagecontact",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Shop",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimageshop",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Departmens",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagedepartmens",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Library",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagelibrary",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Members",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagemembers",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Testimonials",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagetestimonials",
						"std" => "",
						"type" => "upload");

	$options[] = array( "name" => "Other pages",
						"desc" => "Upload an image. Size: 1920x125px",
						"id" => "ale_featuredimagepage",
						"std" => "",
						"type" => "upload");

	$options[] = array( 'name' => 'Custom Widgets',
						'type' => 'heading' );

	$options[] = array( 'name' => 'Our College sidebar',
						'desc' => '',
						'id'   => 'ale_ourcollegesidebar',
						'type' => 'title');

	$options[] = array( 'name' => 'No.1 Sidebar Title',
						'desc' => 'Insert the title',
						'id'   => 'ale_ourcollegesidebartitle1',
						'std'  => 'Expert teachers',
						'type' => 'text');

	$options[] = array( 'name' => 'No.1 Sidebar Text',
						'desc' => 'Insert the text',
						'id'   => 'ale_ourcollegesidebartext1',
						'std'  => 'An utinam reprimique duo, putant mandamus cu qui. Autem possim his cu, quodsi nominavi fabellas ut sit, mea ea ullum epicurei. Saepe tantas ocurreret duo ea, has facilisi vulputate an',
						'type' => 'text');

	$options[] = array( 'name' => 'No.1 Sidebar Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_ourcollegesidebarlink1',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'No.1 Sidebar text for the Link',
						'desc' => 'Insert the text',
						'id'   => 'ale_ourcollegesidebarlinktext1',
						'std'  => 'See more',
						'type' => 'text');

	$options[] = array( 'name' => 'No.2 Sidebar Title',
						'desc' => 'Insert the title',
						'id'   => 'ale_ourcollegesidebartitle2',
						'std'  => 'Library',
						'type' => 'text');

	$options[] = array( 'name' => 'No.2 Sidebar Text',
						'desc' => 'Insert the text',
						'id'   => 'ale_ourcollegesidebartext2',
						'std'  => 'An utinam reprimique duo, putant mandamus cu qui. Autem possim his cu, quodsi nominavi fabellas ut sit, mea ea ullum epicurei. Saepe tantas ocurreret duo ea, has facilisi vulputate an',
						'type' => 'text');

	$options[] = array( 'name' => 'No.2 Sidebar Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_ourcollegesidebarlink2',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'No.2 Sidebar text for the Link',
						'desc' => 'Insert the text',
						'id'   => 'ale_ourcollegesidebarlinktext2',
						'std'  => 'See more',
						'type' => 'text');

	$options[] = array( 'name' => 'No.3 Sidebar Title',
						'desc' => 'Insert the title',
						'id'   => 'ale_ourcollegesidebartitle3',
						'std'  => 'Online course',
						'type' => 'text');

	$options[] = array( 'name' => 'No.3 Sidebar Text',
						'desc' => 'Insert the text',
						'id'   => 'ale_ourcollegesidebartext3',
						'std'  => 'An utinam reprimique duo, putant mandamus cu qui. Autem possim his cu, quodsi nominavi fabellas ut sit, mea ea ullum epicurei. Saepe tantas ocurreret duo ea, has facilisi vulputate an',
						'type' => 'text');

	$options[] = array( 'name' => 'No.3 Sidebar Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_ourcollegesidebarlink3',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'No.3 Sidebar text for the Link',
						'desc' => 'Insert the text',
						'id'   => 'ale_ourcollegesidebarlinktext3',
						'std'  => 'See more',
						'type' => 'text');

	$options[] = array( 'name' => 'Quick Links',
						'desc' => '',
						'id'   => 'ale_quicklinks',
						'type' => 'title');

	$options[] = array( 'name' => 'Title',
						'desc' => 'Insert the title',
						'id'   => 'ale_quicklinkstitle',
						'std'  => 'Quick Links',
						'type' => 'text');

	$options[] = array( 'name' => 'N.1 Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_quicklinkslink1',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'N.1 Text',
						'desc' => 'Insert the text for the link',
						'id'   => 'ale_quicklinkstext1',
						'std'  => 'Courses',
						'type' => 'text');

	$options[] = array( 'name' => 'N.2 Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_quicklinkslink2',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'N.2 Text',
						'desc' => 'Insert the text for the link',
						'id'   => 'ale_quicklinkstext2',
						'std'  => 'Events',
						'type' => 'text');

	$options[] = array( 'name' => 'N.3 Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_quicklinkslink3',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'N.3 Text',
						'desc' => 'Insert the text for the link',
						'id'   => 'ale_quicklinkstext3',
						'std'  => 'Photo',
						'type' => 'text');

	$options[] = array( 'name' => 'N.4 Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_quicklinkslink4',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'No.4 Text',
						'desc' => 'Insert the text for the link',
						'id'   => 'ale_quicklinkstext4',
						'std'  => 'Events',
						'type' => 'text');

	$options[] = array( 'name' => 'N.5 Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_quicklinkslink5',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'No.5 Text',
						'desc' => 'Insert the text for the link',
						'id'   => 'ale_quicklinkstext5',
						'std'  => 'Gallery',
						'type' => 'text');

	$options[] = array( 'name' => 'N.6 Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_quicklinkslink6',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'No.6 Text',
						'desc' => 'Insert the text for the link',
						'id'   => 'ale_quicklinkstext6',
						'std'  => 'Portfolio',
						'type' => 'text');

	$options[] = array( 'name' => 'Summer courses',
						'desc' => '',
						'id'   => 'ale_homesummercourses',
						'type' => 'title');

	$options[] = array( 'name' => 'Title',
						'desc' => 'Insert the title',
						'id'   => 'ale_homesummercoursestitle',
						'std'  => 'Summer courses',
						'type' => 'text');

	$options[] = array( 'name' => 'Text',
						'desc' => 'Insert the text',
						'id'   => 'ale_homesummercoursestext',
						'std'  => 'Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue.',
						'type' => 'text');

	$options[] = array( 'name' => 'Link',
						'desc' => 'Insert the Url',
						'id'   => 'ale_homesummercourseslink',
						'std'  => 'https://www.google.com/',
						'type' => 'text');

	$options[] = array( 'name' => 'Text',
						'desc' => 'Insert the text for the link',
						'id'   => 'ale_homesummercourseslinktext',
						'std'  => 'Start Learning',
						'type' => 'text');

	$options[] = array( 'name' => 'Archives',
						'type' => 'heading');

	$options[] = array( 'name' => 'Course page',
						'desc' => '',
						'id'   => 'ale_coursearchive',
						'std'  => '',
						'type' => 'title');

	$options[] = array( "name" => "Show The Table box",
						"desc" => "Select enable to show the Table box",
						"id"   => "ale_coursetablebox",
						"std"  => "on",
						"type"    => "select",
						"options" => array(
							"on" => "Enable",
							"off" =>  "Disable",
						),);

	$options[] = array( 'name' => 'Text',
						'desc' => 'Insert the title',
						'id'   => 'ale_filtertext',
						'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue.Cras mattis consectetur purus sit amet fermentum. Cras justo odio ibus ac facilisis in, egestas eget quam. Maecenas sed diam eget risus.',
						'type' => 'textarea');

	$options[] = array( 'name' => 'Count',
						'desc' => 'Insert the count on of posts',
						'id'   => 'ale_coursetablecount',
						'std'  => '9',
						'type' => 'text');

	$options[] = array( 'name' => 'Academics page',
						'desc' => '',
						'id'   => 'ale_academicsarchive',
						'std'  => '',
						'type' => 'title');

	$options[] = array( "name" => "Show The Featured Professors box",
						"desc" => "Select enable to show the Featured Professors box",
						"id"   => "ale_academicspagebox",
						"std"  => "on",
						"type"    => "select",
						"options" => array(
							"on" => "Enable",
							"off" =>  "Disable",
						),);

	$options[] = array( 'name' => 'Title',
						'desc' => 'Insert the title',
						'id'   => 'ale_academicspagetitle',
						'std'  => 'Featured Professors',
						'type' => 'text');

	$options[] = array( 'name' => 'Count',
						'desc' => 'Insert the count on of posts',
						'id'   => 'ale_academicspagecount',
						'std'  => '2',
						'type' => 'text');


	$options[] = array( 'name' => 'Testimonials page',
						'desc' => '',
						'id'   => 'ale_testimonialsarchive',
						'std'  => '',
						'type' => 'title');

	$options[] = array( 'name' => 'Title',
						'desc' => 'Insert the title',
						'id'   => 'ale_testimonialsarchivetitle',
						'std'  => 'Lorem Ipsum passages, and more recently with desktop publishing',
						'type' => 'text');

	$options[] = array( 'name' => 'Description',
						'desc' => 'Insert the text',
						'id'   => 'ale_testimonialsarchivedesc',
						'std'  => 'Chris Banson, «Summer poetry»',
						'type' => 'text');

	$options[] = array( 'name' => 'Background',
						'desc' => 'Upload an image. Size: 1920x600px',
						'id'   => 'ale_testimonialsarchivebg',
						'std'  => '',
						'type' => 'upload');

	$options[] = array( 'name' => 'Pagination',
						'type' => 'heading');

	$options[] = array( 'name' => 'Course',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationcurse',
						'std'  => '4',
						'type' => 'text');

	$options[] = array( 'name' => 'Academics',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationacademics',
						'std'  => '8',
						'type' => 'text');

	$options[] = array( 'name' => 'Gallery',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationgallery',
						'std'  => '9',
						'type' => 'text');

	$options[] = array( 'name' => 'Events',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationevents',
						'std'  => '4',
						'type' => 'text');

	$options[] = array( 'name' => 'News',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationnews',
						'std'  => '4',
						'type' => 'text');

	$options[] = array( 'name' => 'Library',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationlibrary',
						'std'  => '4',
						'type' => 'text');

	$options[] = array( 'name' => 'Testimonials',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationtestimonials',
						'std'  => '6',
						'type' => 'text');

	$options[] = array( 'name' => 'Departmens',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationdepartmens',
						'std'  => '9',
						'type' => 'text');

	$options[] = array( 'name' => 'Members',
						'desc' => 'Insert the number of posts to be displayed on the page',
						'id'   => 'ale_paginationmembers',
						'std'  => '12',
						'type' => 'text');

	$options[] = array( "name" => "PayPal",
		"type" => "heading");

	$options[] = array( 'name' => 'Enable PayPal for Courses',
		'desc' => 'Check if you want to enable the PayPal payments for Courses',
		'id'   => 'ale_enable_paypal',
		'std'  => '',
		'type' => 'checkbox',);

	$options[] = array( 'name' => 'PayPal Merchant',
		'desc' => 'Type here the payment merchant email or account ID',
		'id'   => 'ale_merchant_email',
		'std'  => '',
		'type' => 'text',);

	$options[] = array( 'name' => 'PayPal Sandbox for Testing ?',
		'desc' => 'Check if you want to enable the PayPal Sandbox for Testing.',
		'id'   => 'ale_enable_sandbox',
		'std'  => '',
		'type' => 'checkbox',);

	$options[] = array( 'name' => 'Disable SSL secure',
		'desc' => 'Check if you want to disable SSL secure connection for post back.',
		'id'   => 'ale_ssl_disable',
		'std'  => '',
		'type' => 'checkbox',);


	$options[] = array( 'name' => 'Email for verified IPN Reports',
		'desc' => 'Type here the Email address to receive verified IPN Reports. <i>IPN(Instant Payment Notification) report will contain details about payment transaction.</i>',
		'id'   => 'ale_merchant_verified_email',
		'std'  => '',
		'type' => 'text',);

	$options[] = array( 'name' => 'Email for invalid IPN Reports',
		'desc' => 'Type here the Email address to receive invalid IPN Reports. <i>IPN(Instant Payment Notification) report will contain details about payment transaction.</i>',
		'id'   => 'ale_merchant_invalid_email',
		'std'  => '',
		'type' => 'text',);

	$options[] = array( 'name' => 'Currency',
		'desc' => 'Type here the Currency Code. <i>Example: USD</i>',
		'id'   => 'ale_paypal_currency',
		'std'  => 'USD',
		'type' => 'text',);



	return $options;
}

/**
 * Add custom scripts to Options Page
 */
function aletheme_options_custom_scripts() {
 ?>

<script type="text/javascript">
jQuery(document).ready(function() {
	jQuery('#ale_commentongallery').click(function() {
		jQuery('#section-ale_gallerycomments_style').fadeToggle(400);
	});
	if (jQuery('#ale_commentongallery:checked').val() !== undefined) {
		jQuery('#section-ale_gallerycomments_style').show();
	}
});
</script>

<?php
}

/**
 * Add Metaboxes
 * @param array $meta_boxes
 * @return array 
 */
function aletheme_metaboxes($meta_boxes) {
	
	$meta_boxes = array();

	$prefix = "ale_";

	/* Get Members List */
	$members_args = array(
		'post_type' => 'members',
		'posts_per_page' => -1
	);
	$ale_members = new WP_Query( $members_args );
	$members_list[] = array('name' => 'Disable Members', 'value' =>  '');
	if ( $ale_members->have_posts() ) {
		while ( $ale_members->have_posts() ) {
			$ale_members->the_post();
			$members_list[]= array('name' => $ale_members->post->post_title, 'value' =>  $ale_members->post->ID);
		}
	} else {
		$members_list = array(
			array( 'name' => 'No Members in DataBase' , 'value' => '', ),
		);
	}

	/* Get Academics List */
	$academics_args = array(
		'post_type' => 'academics',
		'posts_per_page' => -1
	);
	$ale_academics = new WP_Query( $academics_args );
	$academics_list = array();
	if ( $ale_academics->have_posts() ) {
		while ( $ale_academics->have_posts() ) {
			$ale_academics->the_post();
			$academics_list[$ale_academics->post->ID] = $ale_academics->post->post_title;
		}
	} else {
		$academics_list['0'] = 'No Academics in DataBase';
	}

	$randomPassword = substr(str_shuffle(MD5(microtime())), 0, 10);

	//Font awesome
	$font_awesome = array(
		array('name'=>'check-circle','value'=>'check-circle'),
		array('name'=>'ambulance','value'=>'ambulance'),
		array('name'=>'android','value'=>'android'),
		array('name'=>'apple','value'=>'apple'),
		array('name'=>'archive','value'=>'archive'),
		array('name'=>'asterisk','value'=>'asterisk'),
		array('name'=>'automobile','value'=>'automobile'),
		array('name'=>'backward','value'=>'backward'),
		array('name'=>'ban','value'=>'ban'),
		array('name'=>'bank','value'=>'bank'),
		array('name'=>'bar-chart-o','value'=>'bar-chart-o'),
		array('name'=>'barcode','value'=>'barcode'),
		array('name'=>'bars','value'=>'bars'),
		array('name'=>'beer','value'=>'beer'),
		array('name'=>'behance','value'=>'behance'),
		array('name'=>'behance-square','value'=>'behance-square'),
		array('name'=>'bell','value'=>'bell'),
		array('name'=>'bell-o','value'=>'bell-o'),
		array('name'=>'bitcoin','value'=>'bitcoin'),
		array('name'=>'bolt','value'=>'bolt'),
		array('name'=>'bomb','value'=>'bomb'),
		array('name'=>'book','value'=>'book'),
		array('name'=>'bookmark','value'=>'bookmark'),
		array('name'=>'bookmark-o','value'=>'bookmark-o'),
		array('name'=>'briefcase','value'=>'briefcase'),
		array('name'=>'btc','value'=>'btc'),
		array('name'=>'bug','value'=>'bug'),
		array('name'=>'building','value'=>'building'),
		array('name'=>'building-o','value'=>'building-o'),
		array('name'=>'bullhorn','value'=>'bullhorn'),
		array('name'=>'bullseye','value'=>'bullseye'),
		array('name'=>'cab','value'=>'cab'),
		array('name'=>'calendar','value'=>'calendar'),
		array('name'=>'calendar-o','value'=>'calendar-o'),
		array('name'=>'camera','value'=>'camera'),
		array('name'=>'camera-retro','value'=>'camera-retro'),
		array('name'=>'car','value'=>'car'),
		array('name'=>'certificate','value'=>'certificate'),
		array('name'=>'chain','value'=>'chain'),
		array('name'=>'chain-broken','value'=>'chain-broken'),
		array('name'=>'child','value'=>'child'),
		array('name'=>'clipboard','value'=>'clipboard'),
		array('name'=>'clock-o','value'=>'clock-o'),
		array('name'=>'cloud','value'=>'cloud'),
		array('name'=>'cloud-download','value'=>'cloud-download'),
		array('name'=>'cloud-upload','value'=>'cloud-upload'),
		array('name'=>'cny','value'=>'cny'),
		array('name'=>'code','value'=>'code'),
		array('name'=>'code-fork','value'=>'code-fork'),
		array('name'=>'codepen','value'=>'codepen'),
		array('name'=>'coffee','value'=>'coffee'),
		array('name'=>'cog','value'=>'cog'),
		array('name'=>'cogs','value'=>'cogs'),
		array('name'=>'columns','value'=>'columns'),
		array('name'=>'comment','value'=>'comment'),
		array('name'=>'comment-o','value'=>'comment-o'),
		array('name'=>'comments','value'=>'comments'),
		array('name'=>'comments-o','value'=>'comments-o'),
		array('name'=>'compass','value'=>'compass'),
		array('name'=>'compress','value'=>'compress'),
		array('name'=>'copy','value'=>'copy'),
		array('name'=>'credit-card','value'=>'credit-card'),
		array('name'=>'crop','value'=>'crop'),
		array('name'=>'crosshairs','value'=>'crosshairs'),
		array('name'=>'css3','value'=>'css3'),
		array('name'=>'cube','value'=>'cube'),
		array('name'=>'cubes','value'=>'cubes'),
		array('name'=>'cut','value'=>'cut'),
		array('name'=>'cutlery','value'=>'cutlery'),
		array('name'=>'dashboard','value'=>'dashboard'),
		array('name'=>'database','value'=>'database'),
		array('name'=>'dedent','value'=>'dedent'),
		array('name'=>'delicious','value'=>'delicious'),
		array('name'=>'desktop','value'=>'desktop'),
		array('name'=>'deviantart','value'=>'deviantart'),
		array('name'=>'digg','value'=>'digg'),
		array('name'=>'dollar','value'=>'dollar'),
		array('name'=>'dot-circle-o','value'=>'dot-circle-o'),
		array('name'=>'download','value'=>'download'),
		array('name'=>'dribbble','value'=>'dribbble'),
		array('name'=>'dropbox','value'=>'dropbox'),
		array('name'=>'drupal','value'=>'drupal'),
		array('name'=>'edit','value'=>'edit'),
		array('name'=>'eject','value'=>'eject'),
		array('name'=>'ellipsis-h','value'=>'ellipsis-h'),
		array('name'=>'ellipsis-v','value'=>'ellipsis-v'),
		array('name'=>'envelope','value'=>'envelope'),
		array('name'=>'envelope-o','value'=>'envelope-o'),
		array('name'=>'envelope-square','value'=>'envelope-square'),
		array('name'=>'eraser','value'=>'eraser'),
		array('name'=>'euro','value'=>'euro'),
		array('name'=>'exchange','value'=>'exchange'),
		array('name'=>'exclamation','value'=>'exclamation'),
		array('name'=>'exclamation-circle','value'=>'exclamation-circle'),
		array('name'=>'exclamation-triangle','value'=>'exclamation-triangle'),
		array('name'=>'expand','value'=>'expand'),
		array('name'=>'external-link','value'=>'external-link'),
		array('name'=>'external-link-square','value'=>'external-link-square'),
		array('name'=>'eye','value'=>'eye'),
		array('name'=>'eye-slash','value'=>'eye-slash'),
		array('name'=>'facebook','value'=>'facebook'),
		array('name'=>'facebook-square','value'=>'facebook'),
		array('name'=>'fast-backward','value'=>'fast-backward'),
		array('name'=>'fast-forward','value'=>'fast-forward'),
		array('name'=>'fax','value'=>'fax'),
		array('name'=>'female','value'=>'female'),
		array('name'=>'fighter-jet','value'=>'fighter-jet'),
		array('name'=>'film','value'=>'film'),
		array('name'=>'filter','value'=>'filter'),
		array('name'=>'fire','value'=>'fire'),
		array('name'=>'fire-extinguisher','value'=>'fire-extinguisher'),
		array('name'=>'flag','value'=>'flag'),
		array('name'=>'flag-checkered','value'=>'flag-checkered'),
		array('name'=>'flag-o','value'=>'flag-o'),
		array('name'=>'flash','value'=>'flash'),
		array('name'=>'flask','value'=>'flask'),
		array('name'=>'flickr','value'=>'flickr'),
		array('name'=>'font','value'=>'font'),
		array('name'=>'forward','value'=>'forward'),
		array('name'=>'foursquare','value'=>'foursquare'),
		array('name'=>'frown-o','value'=>'frown-o'),
		array('name'=>'gamepad','value'=>'gamepad'),
		array('name'=>'gavel','value'=>'gavel'),
		array('name'=>'gbp','value'=>'gbp'),
		array('name'=>'ge','value'=>'ge'),
		array('name'=>'gear','value'=>'gear'),
		array('name'=>'gears','value'=>'gears'),
		array('name'=>'gift','value'=>'gift'),
		array('name'=>'gittip','value'=>'gittip'),
		array('name'=>'glass','value'=>'glass'),
		array('name'=>'globe','value'=>'globe'),
		array('name'=>'group','value'=>'group'),
		array('name'=>'h-square','value'=>'h-square'),
		array('name'=>'hacker-news','value'=>'hacker-news'),
		array('name'=>'hand-o-down','value'=>'hand-o-down'),
		array('name'=>'hand-o-left','value'=>'hand-o-left'),
		array('name'=>'hand-o-right','value'=>'hand-o-right'),
		array('name'=>'hand-o-up','value'=>'hand-o-up'),
		array('name'=>'hdd-o','value'=>'hdd-o'),
		array('name'=>'header','value'=>'header'),
		array('name'=>'headphones','value'=>'headphones'),
		array('name'=>'heart','value'=>'heart'),
		array('name'=>'heart-o','value'=>'heart-o'),
		array('name'=>'history','value'=>'history'),
		array('name'=>'home','value'=>'home'),
		array('name'=>'hospital-o','value'=>'hospital-o'),
		array('name'=>'html5','value'=>'html5'),
		array('name'=>'image','value'=>'image'),
		array('name'=>'inbox','value'=>'inbox'),
		array('name'=>'indent','value'=>'indent'),
		array('name'=>'info','value'=>'info'),
		array('name'=>'info-circle','value'=>'info-circle'),
		array('name'=>'inr','value'=>'inr'),
		array('name'=>'instagram','value'=>'instagram'),
		array('name'=>'institution','value'=>'institution'),
		array('name'=>'italic','value'=>'italic'),
		array('name'=>'jpy','value'=>'jpy'),
		array('name'=>'jsfiddle','value'=>'jsfiddle'),
		array('name'=>'key','value'=>'key'),
		array('name'=>'keyboard-o','value'=>'keyboard-o'),
		array('name'=>'krw','value'=>'krw'),
		array('name'=>'language','value'=>'language'),
		array('name'=>'laptop','value'=>'laptop'),
		array('name'=>'leaf','value'=>'leaf'),
		array('name'=>'legal','value'=>'legal'),
		array('name'=>'lemon-o','value'=>'lemon-o'),
		array('name'=>'level-down','value'=>'level-down'),
		array('name'=>'level-up','value'=>'level-up'),
		array('name'=>'life-bouy','value'=>'life-bouy'),
		array('name'=>'life-ring','value'=>'life-ring'),
		array('name'=>'life-saver','value'=>'life-saver'),
		array('name'=>'lightbulb-o','value'=>'lightbulb-o'),
		array('name'=>'link','value'=>'link'),
		array('name'=>'linkedin','value'=>'linkedin'),
		array('name'=>'linkedin-square','value'=>'linkedin-square'),
		array('name'=>'linux','value'=>'linux'),
		array('name'=>'location-arrow','value'=>'location-arrow'),
		array('name'=>'lock','value'=>'lock'),
		array('name'=>'magic','value'=>'magic'),
		array('name'=>'magnet','value'=>'magnet'),
		array('name'=>'mail-forward','value'=>'mail-forward'),
		array('name'=>'mail-reply','value'=>'mail-reply'),
		array('name'=>'mail-reply-all','value'=>'mail-reply-all'),
		array('name'=>'male','value'=>'male'),
		array('name'=>'map-marker','value'=>'map-marker'),
		array('name'=>'maxcdn','value'=>'maxcdn'),
		array('name'=>'medkit','value'=>'medkit'),
		array('name'=>'meh-o','value'=>'meh-o'),
		array('name'=>'microphone','value'=>'microphone'),
		array('name'=>'microphone-slash','value'=>'microphone-slash'),
		array('name'=>'mobile','value'=>'mobile'),
		array('name'=>'mobile-phone','value'=>'mobile-phone'),
		array('name'=>'money','value'=>'money'),
		array('name'=>'moon-o','value'=>'moon-o'),
		array('name'=>'mortar-board','value'=>'mortar-board'),
		array('name'=>'music','value'=>'music'),
		array('name'=>'navicon','value'=>'navicon'),
		array('name'=>'openid','value'=>'openid'),
		array('name'=>'outdent','value'=>'outdent'),
		array('name'=>'pagelines','value'=>'pagelines'),
		array('name'=>'paper-plane-o','value'=>'paper-plane-o'),
		array('name'=>'paperclip','value'=>'paperclip'),
		array('name'=>'paragraph','value'=>'paragraph'),
		array('name'=>'paste','value'=>'paste'),
		array('name'=>'pause','value'=>'pause'),
		array('name'=>'paw','value'=>'paw'),
		array('name'=>'pencil','value'=>'pencil'),
		array('name'=>'pencil-square','value'=>'pencil-square'),
		array('name'=>'pencil-square-o','value'=>'pencil-square-o'),
		array('name'=>'phone','value'=>'phone'),
		array('name'=>'phone-square','value'=>'phone-square'),
		array('name'=>'photo','value'=>'photo'),
		array('name'=>'picture-o','value'=>'picture-o'),
		array('name'=>'pied-piper','value'=>'pied-piper'),
		array('name'=>'pied-piper-alt','value'=>'pied-piper-alt'),
		array('name'=>'pied-piper-square','value'=>'pied-piper-square'),
		array('name'=>'pinterest','value'=>'pinterest'),
		array('name'=>'pinterest-square','value'=>'pinterest-square'),
		array('name'=>'plane','value'=>'plane'),
		array('name'=>'power-off','value'=>'ower-off'),
		array('name'=>'print','value'=>'print'),
		array('name'=>'puzzle-piece','value'=>'puzzle-piece'),
		array('name'=>'qq','value'=>'qq'),
		array('name'=>'qrcode','value'=>'qrcode'),
		array('name'=>'question','value'=>'question'),
		array('name'=>'question-circle','value'=>'question-circle'),
		array('name'=>'quote-left','value'=>'quote-left'),
		array('name'=>'quote-right','value'=>'quote-right'),
		array('name'=>'ra','value'=>'ra'),
		array('name'=>'random','value'=>'random'),
		array('name'=>'recycle','value'=>'recycle'),
		array('name'=>'reddit','value'=>'reddit'),
		array('name'=>'reddit-square','value'=>'reddit-square'),
		array('name'=>'refresh','value'=>'refresh'),
		array('name'=>'renren','value'=>'renren'),
		array('name'=>'reorder','value'=>'reorder'),
		array('name'=>'repeat','value'=>'repeat'),
		array('name'=>'reply','value'=>'reply'),
		array('name'=>'reply-all','value'=>'reply-all'),
		array('name'=>'retweet','value'=>'retweet'),
		array('name'=>'rmb','value'=>'rmb'),
		array('name'=>'road','value'=>'road'),
		array('name'=>'rocket','value'=>'rocket'),
		array('name'=>'rotate-left','value'=>'rotate-left'),
		array('name'=>'rotate-right','value'=>'rotate-right'),
		array('name'=>'rouble','value'=>'rouble'),
		array('name'=>'rss','value'=>'rss'),
		array('name'=>'rss-square','value'=>'rss-square'),
		array('name'=>'ruble','value'=>'ruble'),
		array('name'=>'rupee','value'=>'rupee'),
		array('name'=>'save','value'=>'save'),
		array('name'=>'scissors','value'=>'scissors'),
		array('name'=>'search','value'=>'search'),
		array('name'=>'search-minus','value'=>'search-minus'),
		array('name'=>'search-plus','value'=>'search-plus'),
		array('name'=>'send','value'=>'send'),
		array('name'=>'send-o','value'=>'send-o'),
		array('name'=>'share','value'=>'share'),
		array('name'=>'share-alt','value'=>'share-alt'),
		array('name'=>'share-alt-square','value'=>'share-alt-square'),
		array('name'=>'share-square','value'=>'share-square'),
		array('name'=>'share-square-o','value'=>'share-square-o'),
		array('name'=>'shield','value'=>'shield'),
		array('name'=>'shopping-cart','value'=>'shopping-cart'),
		array('name'=>'sign-in','value'=>'sign-in'),
		array('name'=>'sign-out','value'=>'sign-out'),
		array('name'=>'signal','value'=>'signal'),
		array('name'=>'sitemap','value'=>'sitemap'),
		array('name'=>'skype','value'=>'skype'),
		array('name'=>'slack','value'=>'slack'),
		array('name'=>'sliders','value'=>'sliders'),
		array('name'=>'smile-o','value'=>'smile-o'),
		array('name'=>'soundcloud','value'=>'soundcloud'),
		array('name'=>'space-shuttle','value'=>'space-shuttle'),
		array('name'=>'spinner','value'=>'spinner'),
		array('name'=>'spoon','value'=>'spoon'),
		array('name'=>'spotify','value'=>'spotify'),
		array('name'=>'square','value'=>'square'),
		array('name'=>'square-o','value'=>'square-o'),
		array('name'=>'stack-exchange','value'=>'stack-exchange'),
		array('name'=>'stack-overflow','value'=>'stack-overflow'),
		array('name'=>'star','value'=>'star'),
		array('name'=>'star-half','value'=>'star-half'),
		array('name'=>'star-half-empty','value'=>'star-half-empty'),
		array('name'=>'star-half-full','value'=>'star-half-full'),
		array('name'=>'star-half-o','value'=>'star-half-o'),
		array('name'=>'star-o','value'=>'star-o'),
		array('name'=>'steam','value'=>'steam'),
		array('name'=>'steam-square','value'=>'steam-square'),
		array('name'=>'step-backward','value'=>'step-backward'),
		array('name'=>'step-forward','value'=>'step-forward'),
		array('name'=>'stethoscope','value'=>'stethoscope'),
		array('name'=>'stop','value'=>'stop'),
		array('name'=>'strikethrough','value'=>'strikethrough'),
		array('name'=>'stumbleupon','value'=>'stumbleupon'),
		array('name'=>'stumbleupon-circle','value'=>'stumbleupon-circle'),
		array('name'=>'subscript','value'=>'subscript'),
		array('name'=>'suitcase','value'=>'suitcase'),
		array('name'=>'sun-o','value'=>'sun-o'),
		array('name'=>'superscript','value'=>'superscript'),
		array('name'=>'support','value'=>'support'),
		array('name'=>'table','value'=>'table'),
		array('name'=>'tablet','value'=>'tablet'),
		array('name'=>'tachometer','value'=>'tachometer'),
		array('name'=>'tag','value'=>'tag'),
		array('name'=>'tags','value'=>'tags'),
		array('name'=>'tasks','value'=>'tasks'),
		array('name'=>'taxi','value'=>'taxi'),
		array('name'=>'tencent-weibo','value'=>'tencent-weibo'),
		array('name'=>'terminal','value'=>'terminal'),
		array('name'=>'text-height','value'=>'text-height'),
		array('name'=>'text-width','value'=>'text-width'),
		array('name'=>'thumb-tack','value'=>'thumb-tack'),
		array('name'=>'thumbs-down','value'=>'thumbs-down'),
		array('name'=>'thumbs-o-down','value'=>'thumbs-o-down'),
		array('name'=>'thumbs-o-up','value'=>'thumbs-o-up'),
		array('name'=>'thumbs-up','value'=>'thumbs-up'),
		array('name'=>'ticket','value'=>'ticket'),
		array('name'=>'times','value'=>'times'),
		array('name'=>'times-circle','value'=>'times-circle'),
		array('name'=>'times-circle-o','value'=>'times-circle-o'),
		array('name'=>'trash-o','value'=>'trash-o'),
		array('name'=>'tree','value'=>'tree'),
		array('name'=>'trello','value'=>'trello'),
		array('name'=>'trophy','value'=>'trophy'),
		array('name'=>'truck','value'=>'truck'),
		array('name'=>'try','value'=>'try'),
		array('name'=>'tumblr','value'=>'tumblr'),
		array('name'=>'tumblr-square','value'=>'tumblr-square'),
		array('name'=>'turkish-lira','value'=>'turkish-lira'),
		array('name'=>'twitter','value'=>'twitter'),
		array('name'=>'twitter-square','value'=>'twitter-square'),
		array('name'=>'umbrella','value'=>'umbrella'),
		array('name'=>'underline','value'=>'underline'),
		array('name'=>'undo','value'=>'undo'),
		array('name'=>'unlink','value'=>'unlink'),
		array('name'=>'unlock','value'=>'unlock'),
		array('name'=>'unlock-alt','value'=>'unlock-alt'),
		array('name'=>'unsorted','value'=>'unsorted'),
		array('name'=>'upload','value'=>'upload'),
		array('name'=>'usd','value'=>'usd'),
		array('name'=>'user','value'=>'user'),
		array('name'=>'user-md','value'=>'user-md'),
		array('name'=>'users','value'=>'users'),
		array('name'=>'video-camera','value'=>'video-camera'),
		array('name'=>'vimeo-square','value'=>'vimeo-square'),
		array('name'=>'vine','value'=>'vine'),
		array('name'=>'vk','value'=>'vk'),
		array('name'=>'volume-down','value'=>'volume-down'),
		array('name'=>'volume-off','value'=>'volume-off'),
		array('name'=>'volume-up','value'=>'volume-up'),
		array('name'=>'warning','value'=>'warning'),
		array('name'=>'wechat','value'=>'wechat'),
		array('name'=>'weibo','value'=>'weibo'),
		array('name'=>'wheelchair','value'=>'wheelchair'),
		array('name'=>'windows','value'=>'windows'),
		array('name'=>'won','value'=>'won'),
		array('name'=>'wordpress','value'=>'wordpress'),
		array('name'=>'wrench','value'=>'wrench'),
		array('name'=>'xing','value'=>'xing'),
		array('name'=>'xing-square','value'=>'xing-square'),
		array('name'=>'yahoo','value'=>'yahoo'),
		array('name'=>'yen','value'=>'yen'),
		array('name'=>'youtube','value'=>'youtube'),
		array('name'=>'youtube-play','value'=>'youtube-play'),
		array('name'=>'youtube-square','value'=>'youtube-square'),
	);

	$meta_boxes[] = array(
		'id'         => 'home_page_metabox',
		'title'      => 'Home Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('page-home.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Home page',
				'desc' => '',
				'id'   => $prefix . 'displayhome',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Slider Box?',
				'desc' => 'Select enable to show the Slider box. If you selected the Simple Slider don\'t forget to paste the slider slug in theme options panel' ,
				'id'   => $prefix . 'displayhomeslider',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable (Gallery Slider)', 'value' => 'on', ),
					array( 'name' => 'Simple Slider', 'value' => 'simple', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Information Box?',
				'desc' => 'Select enable to show the Information box',
				'id'   => $prefix . 'displayhomeinfo',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Our College" Box?',
				'desc' => 'Select enable to show the "Our College" box',
				'id'   => $prefix . 'displayhomeourcollege',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "College sidebar, Search Course, Events" Box?',
				'desc' => 'Select enable to show the "College sidebar, Search Course, Events" box',
				'id'   => $prefix . 'displayhomeourcollegeall',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "News" Box?',
				'desc' => 'Select enable to show the "News" box',
				'id'   => $prefix . 'displayhomenews',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Photo Gallery" Box?',
				'desc' => 'Select enable to show the "Photo Gallery" box',
				'id'   => $prefix . 'displayhomephotogallery',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Featured professor" Box?',
				'desc' => 'Select enable to show the "Featured professor" box',
				'id'   => $prefix . 'displayhomefeaturedprofessor',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Slider',
				'id'   => $prefix . 'homeslider',
				'type' => 'title'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of slider items',
				'id'   => $prefix . 'homeslidercount',
				'std'  => '4',
				'type' => 'text'
			),
			array(
				'name' => 'Information',
				'id'   => $prefix . 'homeinformation',
				'type' => 'title'
			),
			array(
				'name' => 'No. 1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homeinformationtitle1',
				'std'  => 'Our college',
				'type' => 'text'
			),
			array(
				'name' => 'No. 1 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeinformationtext1',
				'std'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.',
				'type' => 'text'
			),
			array(
				'name' => 'No. 1 Link',
				'desc' => 'Insert the URL',
				'id'   => $prefix . 'homeinformationurl1',
				'std'  => 'https://www.google.com/',
				'type' => 'text'
			),
			array(
				'name' => 'No. 1 Text of the Link',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeinformationurltext1',
				'std'  => 'See more',
				'type' => 'text'
			),
			array(
				'name' => 'No. 2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homeinformationtitle2',
				'std'  => 'Admissions',
				'type' => 'text'
			),
			array(
				'name' => 'No. 2 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeinformationtext2',
				'std'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.',
				'type' => 'text'
			),
			array(
				'name' => 'No. 2 Link',
				'desc' => 'Insert the URL',
				'id'   => $prefix . 'homeinformationurl2',
				'std'  => 'https://www.google.com/',
				'type' => 'text'
			),
			array(
				'name' => 'No. 2 Text of the Link',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeinformationurltext2',
				'std'  => 'See more',
				'type' => 'text'
			),
			array(
				'name' => 'No. 3 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homeinformationtitle3',
				'std'  => 'Scholarships',
				'type' => 'text'
			),
			array(
				'name' => 'No. 3 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeinformationtext3',
				'std'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.',
				'type' => 'text'
			),
			array(
				'name' => 'No. 3 Link',
				'desc' => 'Insert the URL',
				'id'   => $prefix . 'homeinformationurl3',
				'std'  => 'https://www.google.com/',
				'type' => 'text'
			),
			array(
				'name' => 'No. 3 Text of the Link',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeinformationurltext3',
				'std'  => 'See more',
				'type' => 'text'
			),
			array(
				'name' => 'No. 4 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homeinformationtitle4',
				'std'  => 'Housing',
				'type' => 'text'
			),
			array(
				'name' => 'No. 4 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeinformationtext4',
				'std'  => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry.',
				'type' => 'text'
			),
			array(
				'name' => 'No. 4 Link',
				'desc' => 'Insert the URL',
				'id'   => $prefix . 'homeinformationurl4',
				'std'  => 'https://www.google.com/',
				'type' => 'text'
			),
			array(
				'name' => 'No. 4 Text of the Link',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeinformationurltext4',
				'std'  => 'See more',
				'type' => 'text'
			),
			array(
				'name' => 'Our College',
				'id'   => $prefix . 'homeourcollege',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homeourcollegetitle',
				'std'  => 'Our college',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeourcollegetext',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue.Cras mattis consectetur purus sit amet fermentum. Cras justo odio ibus ac facilisis in, egestas eget quam. Maecenas sed diam eget risus.',
				'type' => 'textarea'
			),
			array(
				'name' => 'Video',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'homeourcollegevideo',
				'std'  => 'https://www.youtube.com/watch?v=6zqpDVyCB2Y',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image for video. Size: 255x135px',
				'id'   => $prefix . 'homeourcollegeimage',
				'std'  => '',
				'type' => 'file'
			),
			array(
				'name' => 'Search Course',
				'id'   => $prefix . 'homeourcollegesearch',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homeourcollegesearchtitle',
				'std'  => 'Search Course',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homeourcollegesearchtext',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue.Cras mattis consectetur purus sit amet fermentum. Cras justo odio ibus ac facilisis in, egestas eget quam. Maecenas sed diam eget risus.',
				'type' => 'text'
			),
			array(
				'name' => 'Events',
				'id'   => $prefix . 'homeourcollegeevents',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homeourcollegeeventstitle',
				'std'  => 'Events',
				'type' => 'text'
			),
			array(
				'name' => 'News',
				'id'   => $prefix . 'homenews',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homenewstitle',
				'std'  => 'News',
				'type' => 'text'
			),
			array(
				'name' => 'Background image',
				'desc' => 'Upload an image. Size: 1920x494px',
				'id'   => $prefix . 'homenewsbackground',
				'std'  => '',
				'type' => 'file'
			),
			array(
				'name' => 'Photo Gallery',
				'id'   => $prefix . 'homephotogallery',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homephotogallerytitle',
				'std'  => 'Photo Gallery',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homephotogallerytext',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue.',
				'type' => 'text'
			),
			array(
				'name' => 'Link',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'homephotogallerylink',
				'std'  => 'See more',
				'type' => 'text'
			),
			array(
				'name' => 'Featured professor',
				'id'   => $prefix . 'homefeaturedprofessor',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'homefeaturedprofessortitle',
				'std'  => 'Featured professor',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'home_page_metabox',
		'title'      => 'Home Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-home-1.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Home page',
				'desc' => '',
				'id'   => $prefix . 'displayhome',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The "Library Filter" Box?',
				'desc' => 'Select enable to show the "Library Filter" box',
				'id'   => $prefix . 'displayhome1library',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Information line" Box in top?',
				'desc' => 'Select enable to show the "Information line" in top',
				'id'   => $prefix . 'displayhome1information',
				'std'  => 'below',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Below', 'value' => 'below', ),
					array( 'name' => 'Top', 'value' => 'top', ),
				),
			),
			array(
				'name' => 'Show The About Box?',
				'desc' => 'Select enable to show the About box',
				'id'   => $prefix . 'displayhome1about',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Description Box?',
				'desc' => 'Select enable to show the Description box',
				'id'   => $prefix . 'displayhome1description',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The People Box?',
				'desc' => 'Select enable to show the People box',
				'id'   => $prefix . 'displayhome1people',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Our catalogue" Box?',
				'desc' => 'Select enable to show the "Our catalogue" box',
				'id'   => $prefix . 'displayhome1catalogue',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Information',
				'id'   => $prefix . 'home1library',
				'type' => 'title'
			),
			array(
				'name' => 'No. 1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1librarytitle1',
				'std'  => 'Beaconhouse',
				'type' => 'text'
			),
			array(
				'name' => 'No. 2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1librarytitle2',
				'std'  => 'National Library',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1librarydesc',
				'std'  => 'There are many variations of passages',
				'type' => 'text'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x590',
				'id'   => $prefix . 'home1librarybg',
				'type' => 'file'
			),
			array(
				'name' => 'About',
				'id'   => $prefix . 'home1about',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1abouttitle',
				'std'  => 'About Milagro',
				'type' => 'text'
			),
			array(
				'name' => 'Blockquote',
				'desc' => 'Insert the blockquote',
				'id'   => $prefix . 'home1aboutblockquote',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue.Cras mattis consectetur purus sit amet fermentum.',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1abouttext',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition. At Wilderness we are committed to being true to the vision of the founders, the Misses Brown, and are guided by their motto \'Semper Verus\', "Always True". They founded this school on their belief in the need for unlimited kindness in relationships, joy in learning and academic adventure, a spirit of humility and the balance between seeking individual excellence and',
				'type' => 'textarea'
			),
			array(
				'name' => 'Link',
				'desc' => 'Insert the url',
				'id'   => $prefix . 'home1aboutlink',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'Image No.1',
				'desc' => 'Upload an image. Size: 429x271px',
				'id'   => $prefix . 'home1aboutimage1',
				'type' => 'file'
			),
			array(
				'name' => 'Image No.2',
				'desc' => 'Upload an image. Size: 429x271px',
				'id'   => $prefix . 'home1aboutimage2',
				'type' => 'file'
			),
			array(
				'name' => 'Image No.3',
				'desc' => 'Upload an image. Size: 271x541px',
				'id'   => $prefix . 'home1aboutimage3',
				'type' => 'file'
			),
			array(
				'name' => 'Information',
				'id'   => $prefix . 'home1information',
				'type' => 'title'
			),
			array(
				'name' => 'Icon No.1',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'home1informationicon1',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'Title No.1',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1informationtitle1',
				'std'  => 'Fiction',
				'type' => 'text'
			),
			array(
				'name' => 'Text No.1',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1informationtext1',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'Icon No.2',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'home1informationicon2',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'Title No.2',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1informationtitle2',
				'std'  => 'Classic',
				'type' => 'text'
			),
			array(
				'name' => 'Text No.2',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1informationtext2',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'Icon No.3',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'home1informationicon3',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'Title No.3',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1informationtitle3',
				'std'  => 'Nonfiction',
				'type' => 'text'
			),
			array(
				'name' => 'Text No.3',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1informationtext3',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'Icon No.4',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'home1informationicon4',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'Title No.4',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1informationtitle4',
				'std'  => 'For students',
				'type' => 'text'
			),
			array(
				'name' => 'Text No.4',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1informationtext4',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'id'   => $prefix . 'home1description',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1descriptiontitle',
				'std'  => 'The wise man therefore always holds',
				'type' => 'text'
			),
			array(
				'name' => 'Blockquote',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1descriptionblockquote',
				'std'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form,',
				'type' => 'text'
			),
			array(
				'name' => 'Bckground',
				'desc' => 'Upload an image. Size: 1920x750px',
				'id'   => $prefix . 'home1descriptionbg',
				'type' => 'file'
			),
			array(
				'name' => 'Our people',
				'id'   => $prefix . 'home1people',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1peopletitle',
				'std'  => 'Our people',
				'type' => 'text'
			),
			array(
				'name' => 'Items count',
				'desc' => 'Insert the count',
				'id'   => $prefix . 'home1peoplecount',
				'std'  => '6',
				'type' => 'text'
			),
			array(
				'name' => 'Our catalogue',
				'id'   => $prefix . 'home1catalogue',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1cataloguetitle',
				'std'  => 'Our catalogue',
				'type' => 'text'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x1100',
				'id'   => $prefix . 'home1cataloguebg',
				'type' => 'file'
			),
			array(
				'name' => 'Sundries',
				'id'   => $prefix . 'home1sundries',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home1sundriestitle',
				'std'  => 'On the other hand, we denounce with righteous indignation and dislike',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1sundriestext',
				'std'  => 'But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of',
				'type' => 'textarea'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 431x552',
				'id'   => $prefix . 'home1sundriesimage',
				'type' => 'file'
			),
			array(
				'name' => 'Person Photo',
				'desc' => 'Upload an image. Size: 148x216',
				'id'   => $prefix . 'home1sundriespersonphoto',
				'type' => 'file'
			),
			array(
				'name' => 'Person Name',
				'desc' => 'Insert the name',
				'id'   => $prefix . 'home1sundriespersonname',
				'std'  => 'Anna Richards',
				'type' => 'text'
			),
			array(
				'name' => 'Person Post',
				'desc' => 'Insert the post',
				'id'   => $prefix . 'home1sundriespersonpost',
				'std'  => 'Co-founder',
				'type' => 'text'
			),
			array(
				'name' => 'Person Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home1sundriespersondescription',
				'std'  => 'On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure',
				'type' => 'textarea'
			),
			array(
				'name' => 'Person Sign',
				'desc' => 'Upload an image. Size: 92x30',
				'id'   => $prefix . 'home1sundriespersonsign',
				'type' => 'file'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'home_page_metabox',
		'title'      => 'Home Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-home-2.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Home page',
				'desc' => '',
				'id'   => $prefix . 'displayhome',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Slider Box?',
				'desc' => 'Select enable to show the Slider box',
				'id'   => $prefix . 'displayhome2slider',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable (Events Slider)', 'value' => 'on', ),
					array( 'name' => 'Simple Slider', 'value' => 'simple', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Courses Box?',
				'desc' => 'Select enable to show the Courses box',
				'id'   => $prefix . 'displayhome2courses',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Library Categories Box?',
				'desc' => 'Select enable to show the Library Categories box',
				'id'   => $prefix . 'displayhome2librarycat',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Library Box?',
				'desc' => 'Select enable to show the Library box',
				'id'   => $prefix . 'displayhome2library',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Blockquote Box?',
				'desc' => 'Select enable to show the Blockquote box',
				'id'   => $prefix . 'displayhome2blockquote',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "News, Video, Subscribe Form" Box?',
				'desc' => 'Select enable to show the "News, Video, Subscribe Form" box',
				'id'   => $prefix . 'displayhome2news',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Blog Box?',
				'desc' => 'Select enable to show the Blog box',
				'id'   => $prefix . 'displayhome2blog',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Slider',
				'id'   => $prefix . 'home2slider',
				'type' => 'title'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of slider items',
				'id'   => $prefix . 'home2slidercount',
				'std'  => '3',
				'type' => 'text'
			),
			array(
				'name' => 'Our courses',
				'id'   => $prefix . 'home2courses',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home2coursestitle',
				'std'  => 'Our courses',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home2coursesdesc',
				'std'  => 'Some description here',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home2coursestext',
				'std'  => 'On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot forese',
				'type' => 'text'
			),
			array(
				'name' => 'Library categories',
				'id'   => $prefix . 'home2librarycat',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home2librarycattitle',
				'std'  => 'Categories',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 1098x606px',
				'id'   => $prefix . 'home2librarycatimage',
				'type' => 'file'
			),
			array(
				'name' => 'Library',
				'id'   => $prefix . 'home2library',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home2librarytitle',
				'std'  => 'There are many variations',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home2librarydesc',
				'std'  => 'Some description here',
				'type' => 'text'
			),
			array(
				'name' => 'Blockquote',
				'id'   => $prefix . 'home2blockquote',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home2blockquotetitle',
				'std'  => 'Lorem Ipsum passages, and more recently with desktop publishing',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home2blockquotetext',
				'std'  => 'Chris Banson, «Summer poetry»',
				'type' => 'text'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x810px',
				'id'   => $prefix . 'home2blockquotebg',
				'type' => 'file'
			),
			array(
				'name' => 'News',
				'id'   => $prefix . 'home2news',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home2newstitle',
				'std'  => 'Recent news',
				'type' => 'text'
			),
			array(
				'name' => 'Video about us',
				'id'   => $prefix . 'home2videoabout',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home2videoabouttitle',
				'std'  => 'Video about us',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 525x317px',
				'id'   => $prefix . 'home2videoaboutimage',
				'type' => 'file'
			),
			array(
				'name' => 'Url',
				'desc' => 'Insert the url of the video',
				'id'   => $prefix . 'home2videoaboutvideo',
				'std'  => 'https://www.youtube.com/watch?v=OdIJ2x3nxzQ',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'home_page_metabox',
		'title'      => 'Home Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-home-3.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Home page',
				'desc' => '',
				'id'   => $prefix . 'displayhome',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Events Box?',
				'desc' => 'Select enable to show the Events box',
				'id'   => $prefix . 'displayhome3slider',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable (Events with Timer)', 'value' => 'on', ),
					array( 'name' => 'Simple Slider', 'value' => 'simple', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Information Box?',
				'desc' => 'Select enable to show the Information box',
				'id'   => $prefix . 'displayhome3info',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Testimonials Box?',
				'desc' => 'Select enable to show the Testimonials box',
				'id'   => $prefix . 'displayhome3testimonials',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Twitter Box?',
				'desc' => 'Select enable to show the Twitter box',
				'id'   => $prefix . 'displayhome3twitter',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Gallery Box?',
				'desc' => 'Select enable to show the Gallery box',
				'id'   => $prefix . 'displayhome3gallery',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Blog Box?',
				'desc' => 'Select enable to show the Blog box',
				'id'   => $prefix . 'displayhome3blog',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Subscribe Box?',
				'desc' => 'Select enable to show the Subscribe box',
				'id'   => $prefix . 'displayhome3subscribe',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Our people" Box?',
				'desc' => 'Select enable to show the "Our people" box',
				'id'   => $prefix . 'displayhome3people',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Events',
				'id'   => $prefix . 'home3slider',
				'type' => 'title'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of slider items',
				'id'   => $prefix . 'home3slidercount',
				'std'  => '3',
				'type' => 'text'
			),
			array(
				'name' => 'Information',
				'id'   => $prefix . 'home3info',
				'type' => 'title'
			),
			array(
				'name' => 'No.1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home3infotitle1',
				'std'  => 'For Students',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infodesc1',
				'std'  => 'Two years course',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Line (1)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline11',
				'std'  => 'If you are going to use a passage',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Line (2)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline12',
				'std'  => 'All the Lorem Ipsum generators',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Line (3)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline13',
				'std'  => 'It uses a dictionary ',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Line (4)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline14',
				'std'  => 'Words which don\'t look even',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Price',
				'desc' => 'Insert the Price. Example: $56',
				'id'   => $prefix . 'home3infoprice1',
				'std'  => '$56',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home3infotitle2',
				'std'  => 'Spanish',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infodesc2',
				'std'  => 'Two years course',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Line (1)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline21',
				'std'  => 'If you are going to use a passage',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Line (2)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline22',
				'std'  => 'All the Lorem Ipsum generators',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Line (3)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline23',
				'std'  => 'It uses a dictionary ',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Line (4)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline24',
				'std'  => 'Words which don\'t look even',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Price',
				'desc' => 'Insert the Price. Example: $56',
				'id'   => $prefix . 'home3infoprice2',
				'std'  => '$56',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home3infotitle3',
				'std'  => 'Itallian',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infodesc3',
				'std'  => 'Two years course',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Line (1)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline31',
				'std'  => 'If you are going to use a passage',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Line (2)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline32',
				'std'  => 'All the Lorem Ipsum generators',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Line (3)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline33',
				'std'  => 'It uses a dictionary ',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Line (4)',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3infoline34',
				'std'  => 'Words which don\'t look even',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Price',
				'desc' => 'Insert the Price. Example: $56',
				'id'   => $prefix . 'home3infoprice3',
				'std'  => '$56',
				'type' => 'text'
			),
			array(
				'name' => 'Testimonials',
				'id'   => $prefix . 'home3testimonials',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home3testimonialstitle',
				'std'  => 'On the other hand, we denounce with righteous indignation',
				'type' => 'text'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of slider items',
				'id'   => $prefix . 'home3testimonialscount',
				'std'  => '3',
				'type' => 'text'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload na image. Size: 920x850px',
				'id'   => $prefix . 'home3testimonialsbg',
				'type' => 'file'
			),
			array(
				'name' => 'Gallery',
				'id'   => $prefix . 'home3gallery',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home3gallerytitle',
				'std'  => 'Gallery',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3gallerydesc',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet.',
				'type' => 'text'
			),
			array(
				'name' => 'Blog',
				'id'   => $prefix . 'home3blog',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home3blogtitle',
				'std'  => 'Blog',
				'type' => 'text'
			),
			array(
				'name' => 'Link',
				'desc' => 'Insert the text of the link to blog',
				'id'   => $prefix . 'home3bloglink',
				'std'  => 'Go to blog',
				'type' => 'text'
			),
			array(
				'name' => 'Our people',
				'id'   => $prefix . 'home3people',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home3peopletitle',
				'std'  => 'Our people',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home3peopledesc',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet.',
				'type' => 'text'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of slider items',
				'id'   => $prefix . 'home3memberscount',
				'std'  => '10',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'home_page_metabox',
		'title'      => 'Home Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-home-4.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Home page',
				'desc' => '',
				'id'   => $prefix . 'displayhome',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Slider Box?',
				'desc' => 'Select enable to show the Slider box',
				'id'   => $prefix . 'displayhome4slider',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable (Gallery Slider)', 'value' => 'on', ),
					array( 'name' => 'Simple Slider', 'value' => 'simple', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The About Box?',
				'desc' => 'Select enable to show the About box',
				'id'   => $prefix . 'displayhome4about',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Table Box?',
				'desc' => 'Select enable to show the Table box',
				'id'   => $prefix . 'displayhome4table',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The News Box?',
				'desc' => 'Select enable to show the News box',
				'id'   => $prefix . 'displayhome4news',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The History Box?',
				'desc' => 'Select enable to show the History box',
				'id'   => $prefix . 'displayhome4history',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Text Box?',
				'desc' => 'Select enable to show the Text box',
				'id'   => $prefix . 'displayhome4text',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Partners Box?',
				'desc' => 'Select enable to show the Partners box',
				'id'   => $prefix . 'displayhome4partners',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'About',
				'id'   => $prefix . 'home4about',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home4abouttitle',
				'std'  => 'About Milagro',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home4aboutdesc',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 389x674px',
				'id'   => $prefix . 'home4aboutimage',
				'type' => 'file'
			),
			array(
				'name' => 'Table',
				'id'   => $prefix . 'home4table',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home4home4tabletitle',
				'std'  => 'Timetable',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home4tabledesc',
				'std'  => 'Some description here',
				'type' => 'text'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x740px',
				'id'   => $prefix . 'home4tablebg',
				'type' => 'file'
			),
			array(
				'name' => 'News',
				'id'   => $prefix . 'home4news',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home4newstitle',
				'std'  => 'Recent news',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home4newsdesc',
				'std'  => 'Some description here',
				'type' => 'text'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of slider items',
				'id'   => $prefix . 'home4newscount',
				'std'  => '6',
				'type' => 'text'
			),
			array(
				'name' => 'History',
				'id'   => $prefix . 'home4history',
				'type' => 'title'
			),
			array(
				'name' => 'Title No.1',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home4historytitle',
				'std'  => 'Our',
				'type' => 'text'
			),
			array(
				'name' => 'Title No.2',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home4historytitle2',
				'std'  => 'history',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home4historydesc',
				'std'  => 'Some description here',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'id'   => $prefix . 'home4text',
				'type' => 'title'
			),
			array(
				'name' => 'Title No.1',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home4texttitle1',
				'std'  => 'Lorem Ipsum is simply dummy',
				'type' => 'text'
			),
			array(
				'name' => 'Title No.2',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home4texttitle2',
				'std'  => 'Printing and typesetting industry',
				'type' => 'text'
			),
			array(
				'name' => 'Partners',
				'id'   => $prefix . 'home4partners',
				'type' => 'title'
			),
			array(
				'name' => 'No.1 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'home4partnersimage1',
				'type' => 'file'
			),
			array(
				'name' => 'No.1 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'home4partnerslink1',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'home4partnersimage2',
				'type' => 'file'
			),
			array(
				'name' => 'No.2 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'home4partnerslink2',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'home4partnersimage3',
				'type' => 'file'
			),
			array(
				'name' => 'No.3 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'home4partnerslink3',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'home4partnersimage4',
				'type' => 'file'
			),
			array(
				'name' => 'No.4 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'home4partnerslink4',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.5 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'home4partnersimage5',
				'type' => 'file'
			),
			array(
				'name' => 'No.5 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'home4partnerslink5',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.6 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'home4partnersimage6',
				'type' => 'file'
			),
			array(
				'name' => 'No.6 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'home4partnerslink6',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'home_page_metabox',
		'title'      => 'Home Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-home-5.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Home page',
				'desc' => '',
				'id'   => $prefix . 'displayhome',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Slider Box?',
				'desc' => 'Select enable to show the Slider box',
				'id'   => $prefix . 'displayhome5slider',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable (Library Slider)', 'value' => 'on', ),
					array( 'name' => 'Simple Slider', 'value' => 'simple', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Information Box?',
				'desc' => 'Select enable to show the Information box',
				'id'   => $prefix . 'displayhome5info',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Corses and Statistics" Box?',
				'desc' => 'Select enable to show the "Corses and Statistics" box',
				'id'   => $prefix . 'displayhome5courses',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Description Box?',
				'desc' => 'Select enable to show the Description box',
				'id'   => $prefix . 'displayhome5desc',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Blog Box?',
				'desc' => 'Select enable to show the Blog box',
				'id'   => $prefix . 'displayhome5blog',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Contact Box?',
				'desc' => 'Select enable to show the Contact box',
				'id'   => $prefix . 'displayhome5contact',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Slider',
				'id'   => $prefix . 'home5slider',
				'type' => 'title'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of slider items',
				'id'   => $prefix . 'home5slidercount',
				'std'  => '3',
				'type' => 'text'
			),
			array(
				'name' => 'Information',
				'id'   => $prefix . 'home5info',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5infotitle',
				'std'  => 'There are many variations of passages of Lorem Ipsum available',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5infodesc',
				'std'  => 'These cases are perfectly simple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Number',
				'desc' => 'Insert the number',
				'id'   => $prefix . 'home5infonumber1',
				'std'  => '24',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5infotext1',
				'std'  => 'Courses',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Number',
				'desc' => 'Insert the number',
				'id'   => $prefix . 'home5infonumber2',
				'std'  => '18',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5infotext2',
				'std'  => 'Years',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Number',
				'desc' => 'Insert the number',
				'id'   => $prefix . 'home5infonumber3',
				'std'  => '53',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5infotext3',
				'std'  => 'Teachers',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Number',
				'desc' => 'Insert the number',
				'id'   => $prefix . 'home5infonumber4',
				'std'  => '480',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5infotext4',
				'std'  => 'Students',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 440x546px',
				'id'   => $prefix . 'home5infoimage',
				'type' => 'file'
			),
			array(
				'name' => 'Courses',
				'id'   => $prefix . 'home5courses',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5coursestitle',
				'std'  => 'Our courses',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5coursesdesc',
				'std'  => 'Some description here',
				'type' => 'text'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x240px',
				'id'   => $prefix . 'home5coursesimage',
				'type' => 'file'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count fo slider items',
				'id'   => $prefix . 'home5coursescount',
				'std'  => '3',
				'type' => 'text'
			),
			array(
				'name' => 'Statistics',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5coursesstatistics',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5coursesstatisticstitle',
				'std'  => 'There are many variations of passages of Lorem Ipsum available',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5coursesstatisticstext',
				'std'  => 'These cases are perfectly simple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when ',
				'type' => 'text'
			),
			array(
				'name' => 'Year',
				'desc' => 'Insert the year',
				'id'   => $prefix . 'home5coursesstatisticsyear',
				'std'  => '2014',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5coursesstatisticstitle1',
				'std'  => 'Students',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Procent',
				'desc' => 'Insert the number. Example: 94',
				'id'   => $prefix . 'home5coursesstatisticsprocent1',
				'std'  => '94',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5coursesstatisticstitle2',
				'std'  => 'Teachers',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Procent',
				'desc' => 'Insert the number. Example: 75',
				'id'   => $prefix . 'home5coursesstatisticsprocent2',
				'std'  => '70',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5coursesstatisticstitle3',
				'std'  => 'Experience',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Procent',
				'desc' => 'Insert the number. Example: 60',
				'id'   => $prefix . 'home5coursesstatisticsprocent3',
				'std'  => '60',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => '',
				'id'   => $prefix . 'home5description',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5descriptiontitle',
				'std'  => 'It has roots in a piece of classical Latin literature',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5descriptiontext',
				'std'  => 'Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia',
				'type' => 'text'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x680px',
				'id'   => $prefix . 'home5descriptionbg',
				'type' => 'file'
			),
			array(
				'name' => 'Blog',
				'desc' => '',
				'id'   => $prefix . 'home5blog',
				'type' => 'title'
			),
			array(
				'name' => 'No.1 Title',
				'desc' => 'Insert the first part of the title',
				'id'   => $prefix . 'home5blogtitle1',
				'std'  => 'Our',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Title',
				'desc' => 'Insert the second part of the title',
				'id'   => $prefix . 'home5blogtitle2',
				'std'  => 'blog',
				'type' => 'text'
			),
			array(
				'name' => 'Contact',
				'desc' => '',
				'id'   => $prefix . 'home5contact',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'home5contacttitle',
				'std'  => 'There are many variations of passages of Lorem Ipsum available',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'home5contactdesc',
				'std'  => 'These cases are perfectly simple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when ',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'about_page_metabox',
		'title'      => 'About Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-about.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on About page',
				'desc' => '',
				'id'   => $prefix . 'displayabout',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Content Box?',
				'desc' => 'Select enable to show the Content box',
				'id'   => $prefix . 'displayaboutcontent',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "History, Mission" Box?',
				'desc' => 'Select enable to show the "History, Mission" box',
				'id'   => $prefix . 'displayabouthistorymission',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Featured professor" Box?',
				'desc' => 'Select enable to show the "Featured professor" box',
				'id'   => $prefix . 'displayaboutfeaturedprofessor',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Content block',
				'id'   => $prefix . 'aboutpage',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'aboutpagetitle',
				'std'  => 'About Milagro',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'aboutpagetext',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla vitae elit libero, a pharetra augue.Cras mattis consectetur purus sit amet fermentum. Cras justo odio ibus ac facilisis in, egestas eget quam. Maecenas sed diam eget risus.',
				'type' => 'textarea'
			),
			array(
				'name' => 'Text No.2',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'aboutpagetext2',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition. At Wilderness we are committed to being true to the vision of the founders, the Misses Brown, and are guided by their motto \'Semper Verus\', "Always True". They founded this school on their belief in the need for unlimited kindness in relationships, joy in learning and academic adventure, a spirit of humility and the balance between seeking individual excellence and success and generous service to the community. These values still guide every part of Wilderness School\s culture, relationships, teaching and learning programs and practices. We are dedicated to providing a firm foundation and inspiration for a challenging, demanding and fulfilling life in which each individual can discover and develop her gifts, find inner balance, make true friends and be enabled to contribute to and act for the common good.',
				'type' => 'textarea'
			),
			array(
				'name' => 'Video',
				'id'   => $prefix . 'aboutpagevide',
				'type' => 'title'
			),
			array(
				'name' => 'Link for video',
				'desc' => 'Insert the url',
				'id'   => $prefix . 'aboutpagevideourl',
				'std'  => 'https://www.youtube.com/watch?v=4mEbABPtTv8',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 588x320px',
				'id'   => $prefix . 'aboutpagevideoimage',
				'std'  => '',
				'type' => 'file'
			),
			array(
				'name' => 'Google plus',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'aboutpagevideogog',
				'std'  => 'https://plus.google.com/',
				'type' => 'text'
			),
			array(
				'name' => 'Twitter',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'aboutpagevideotwi',
				'std'  => 'https://twitter.com/',
				'type' => 'text'
			),
			array(
				'name' => 'Facebook',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'aboutpagevideofb',
				'std'  => 'https://www.facebook.com/',
				'type' => 'text'
			),
			array(
				'name' => 'History',
				'id'   => $prefix . 'abouthistory',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'abouthistorytitle',
				'std'  => 'History',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'abouthistorytext',
				'std'  => 'An utinam reprimique duo, putant mandamus cu qui. Autem possim his cu, quodsi nominavi fabellas ut sit, mea ea ullum epicurei. An utinam reprimique duo, putant mandamus cu qui. Autem possim his cu, quodsi nominavi fabellas ut sit, mea ea ullum epicurei.',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'abouthistorylink1',
				'std'  => 'https://www.google.com/',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Image',
				'desc' => 'Upload an image. Size: 164x108px',
				'id'   => $prefix . 'abouthistoryimage1',
				'std'  => '',
				'type' => 'file'
			),
			array(
				'name' => 'No.2 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'abouthistorylink2',
				'std'  => 'https://www.google.com/',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Image',
				'desc' => 'Upload an image. Size: 164x108px',
				'id'   => $prefix . 'abouthistoryimage2',
				'std'  => '',
				'type' => 'file'
			),
			array(
				'name' => 'No.3 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'abouthistorylink3',
				'std'  => 'https://www.google.com/',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Image',
				'desc' => 'Upload an image. Size: 164x108px',
				'id'   => $prefix . 'abouthistoryimage3',
				'std'  => '',
				'type' => 'file'
			),
			array(
				'name' => 'Mission',
				'id'   => $prefix . 'aboutmission',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'aboutmissiontitle',
				'std'  => 'Mission',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'aboutmissiontext',
				'std'  => 'An utinam reprimique duo, putant mandamus cu qui. Autem possim his cu, quodsi nominavi fabellas ut sit, mea ea ullum epicurei. An utinam reprimique duo, putant mandamus cu qui. Autem possim his cu, quodsi nominavi fabellas ut sit, mea ea ullum epicurei.',
				'type' => 'text'
			),
			array(
				'name' => 'Featured professor',
				'id'   => $prefix . 'aboutfeaturedprofessor',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'aboutfeaturedprofessortitle',
				'std'  => 'Featured professor',
				'type' => 'text'
			),
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of posts',
				'id'   => $prefix . 'aboutfeaturedprofessorcount',
				'std'  => '3',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'about_page_metabox',
		'title'      => 'About Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-about-1.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on About page',
				'desc' => '',
				'id'   => $prefix . 'displayabout',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Information Box?',
				'desc' => 'Select enable to show the Information box',
				'id'   => $prefix . 'displayabout1info',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The About Box?',
				'desc' => 'Select enable to show the About box',
				'id'   => $prefix . 'displayabout1about',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Courses Box?',
				'desc' => 'Select enable to show the Courses box',
				'id'   => $prefix . 'displayabout1courses',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "Featured professor" Box?',
				'desc' => 'Select enable to show the "Featured professor" box',
				'id'   => $prefix . 'displayabout1professors',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Partners Box?',
				'desc' => 'Select enable to show the Partners box',
				'id'   => $prefix . 'displayabout1partners',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Information',
				'id'   => $prefix . 'about1info',
				'type' => 'title'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x300px',
				'id'   => $prefix . 'about1infobg',
				'type' => 'file'
			),
			array(
				'name' => 'No.1 Icon',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'about1infoicon1',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'about1infotitle1',
				'std'  => 'Fiction',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'about1infotext1',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Icon',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'about1infoicon2',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'about1infotitle2',
				'std'  => 'Classic',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'about1infotext2',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Icon',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'about1infoicon3',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.3 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'about1infotitle3',
				'std'  => 'Nonfiction',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'about1infotext3',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Icon',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'about1infoicon4',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.4 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'about1infotitle4',
				'std'  => 'For students',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'about1infotext4',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'About',
				'id'   => $prefix . 'about1about',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'about1abouttitle',
				'std'  => 'About Milagro',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'about1aboutdesc',
				'std'  => 'Curabitur blandit tempus porttitor. Integer posuere erat a ante venenatis dapibus posuere velit aliquet. Nulla',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 389x674px',
				'id'   => $prefix . 'about1aboutimage',
				'type' => 'file'
			),
			array(
				'name' => 'Our courses',
				'id'   => $prefix . 'about1courses',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'about1coursestitle',
				'std'  => 'Our courses',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'about1coursesdesc',
				'std'  => 'Some description here',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'about1coursestext',
				'std'  => 'On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot forese',
				'type' => 'text'
			),
			array(
				'name' => 'Featured professor',
				'id'   => $prefix . 'about1featuredprofessor',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'about1featuredprofessortitle',
				'std'  => 'Featured professor',
				'type' => 'text'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x505px',
				'id'   => $prefix . 'about1featuredprofessorbg',
				'type' => 'file'
			),
			array(
				'name' => 'Partners',
				'id'   => $prefix . 'about1partners',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'about1partnerstitle',
				'std'  => 'Our partners',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'about1partnerstext',
				'std'  => 'It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout. The point of using Lorem Ipsum is that it has a more-or-less normal distribution of letters, as opposed to using',
				'type' => 'textarea'
			),
			array(
				'name' => 'No.1 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'about1partnersimage1',
				'type' => 'file'
			),
			array(
				'name' => 'No.1 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'about1partnerslink1',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'about1partnersimage2',
				'type' => 'file'
			),
			array(
				'name' => 'No.2 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'about1partnerslink2',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'about1partnersimage3',
				'type' => 'file'
			),
			array(
				'name' => 'No.3 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'about1partnerslink3',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'about1partnersimage4',
				'type' => 'file'
			),
			array(
				'name' => 'No.4 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'about1partnerslink4',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.5 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'about1partnersimage5',
				'type' => 'file'
			),
			array(
				'name' => 'No.5 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'about1partnerslink5',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'No.6 Image',
				'desc' => 'Upload an image. Size: 166x142px',
				'id'   => $prefix . 'about1partnersimage6',
				'type' => 'file'
			),
			array(
				'name' => 'No.6 Link',
				'desc' => 'Insert the Url',
				'id'   => $prefix . 'about1partnerslink6',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'course_page_metabox',
		'title'      => 'Course Page Options',
		'pages'      => array( 'course', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'coursedesc',
				'type' => 'text'
			),
			array(
				'name' => 'Instructor',
				'desc' => 'Insert the name',
				'id'   => $prefix . 'courseinstructor',
				'type' => 'text'
			),
			array(
				'name' => 'Room Number',
				'desc' => 'Insert the number',
				'id'   => $prefix . 'courseroom',
				'type' => 'text'
			),
			array(
				'name' => 'Course ID',
				'desc' => 'Insert the number',
				'id'   => $prefix . 'courseid',
				'type' => 'text'
			),
			array(
				'name' => 'Time',
				'desc' => 'Insert the number. Example: 13.00-16.00',
				'id'   => $prefix . 'coursetime',
				'type' => 'text'
			),
			array(
				'name' => 'Hours of training',
				'desc' => '',
				'id'   => $prefix . 'coursehourse',
				'type' => 'title'
			),
			array(
				'name' => 'January',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehoursejanuary',
				'type' => 'text'
			),
			array(
				'name' => 'February',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehoursefebruary',
				'type' => 'text'
			),
			array(
				'name' => 'March',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehoursemarch',
				'type' => 'text'
			),
			array(
				'name' => 'April',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehourseapril',
				'type' => 'text'
			),
			array(
				'name' => 'May',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehoursemay',
				'type' => 'text'
			),
			array(
				'name' => 'June',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehoursejune',
				'type' => 'text'
			),
			array(
				'name' => 'July',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehoursejuly',
				'type' => 'text'
			),
			array(
				'name' => 'August',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehourseaugust',
				'type' => 'text'
			),
			array(
				'name' => 'September',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehourseseptember',
				'type' => 'text'
			),
			array(
				'name' => 'October',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehourseoctober',
				'type' => 'text'
			),
			array(
				'name' => 'November',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehoursenovember',
				'type' => 'text'
			),
			array(
				'name' => 'December',
				'desc' => 'Insert the number. Example: 25h',
				'id'   => $prefix . 'coursehoursedecember',
				'type' => 'text'
			),
			array(
				'name' => 'Show This post on selected members post?',
				'desc' => 'Select enable to show this post single page',
				'id'   => $prefix . 'coursemember',
				'std'  => '',
				'type'    => 'select',
				'options' => $members_list,
			),
			array(
				'name' => 'Show This post on service page?',
				'desc' => 'Select enable to show this post on service page',
				'id'   => $prefix . 'courseservice',
				'std'  => '',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Disable', 'value' => 'off', ),
					array( 'name' => 'Enable', 'value' => 'on', ),
				),
			),
			array(
				'name' => 'Show This post on Archive page?',
				'desc' => 'Select enable to show this post on Archive page',
				'id'   => $prefix . 'coursearchive',
				'std'  => '',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Disable', 'value' => 'off', ),
					array( 'name' => 'Enable', 'value' => 'on', ),
				),
			),
			array(
				'name' => 'Additional details',
				'desc' => '',
				'id'   => $prefix . 'courseadditional',
				'type' => 'title'
			),
			array(
				'name' => 'Students Participate',
				'desc' => 'Insert the students count. Example: 53 Students',
				'id'   => $prefix . 'coursestudentscount',
				'type' => 'text'
			),
			array(
				'name' => 'Lessons Count',
				'desc' => 'Insert the lessons count info. Example: 10 Lessons',
				'id'   => $prefix . 'courselessonscount',
				'type' => 'text'
			),
			array(
				'name' => 'Duration of the course',
				'desc' => 'Insert the text. Example: Two years course',
				'id'   => $prefix . 'courseadditionalduration',
				'type' => 'text'
			),
			array(
				'name' => 'Price of the course',
				'desc' => 'Insert the text. Example: $56',
				'id'   => $prefix . 'courseadditionalprice',
				'type' => 'text'
			),
			array(
				'name' => 'Date of payment',
				'desc' => 'Insert the text. Example: month',
				'id'   => $prefix . 'courseadditionaldate',
				'std'  => 'month',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 custom field',
				'desc' => 'Insert the text.',
				'id'   => $prefix . 'courseadditionalfield1',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 custom field',
				'desc' => 'Insert the text.',
				'id'   => $prefix . 'courseadditionalfield2',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 custom field',
				'desc' => 'Insert the text.',
				'id'   => $prefix . 'courseadditionalfield3',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 custom field',
				'desc' => 'Insert the text.',
				'id'   => $prefix . 'courseadditionalfield4',
				'std'  => '',
				'type' => 'text'
			),

			array(
				'name' => 'Payment description',
				'desc' => 'Insert the text.',
				'id'   => $prefix . 'coursepaymentdescription',
				'type' => 'textarea_code'
			),

			array(
				'name' => 'Select Courses Staff',
				'desc' => 'Check Staff that is responsible for the current cource',
				'id'   => $prefix . 'courcestaf',
				'std'  => '',
				'type'    => 'multicheck',
				'options' => $academics_list,
			),

			array(
				'name' => 'Show Gallery Section',
				'desc' => 'Select enable to show this section',
				'id'   => $prefix . 'gallerysectionshow',
				'std'  => '',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Disable', 'value' => 'off', ),
					array( 'name' => 'Enable', 'value' => 'on', ),
				),
			),
			array(
				'name' => 'Password for Protected Area',
				'desc' => 'Insert here the text.',
				'id'   => $prefix . 'courseprotectedpassword',
				'std'  => $randomPassword,
				'type' => 'text'
			),
			array(
				'name' => 'Protected Content',
				'desc' => 'Insert here the protected content. The field support HTML. so you can add different data.',
				'id'   => $prefix . 'protectedcontent',
				'std'  => '',
				'type' => 'textarea_code'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'contact_page_metabox',
		'title'      => 'Contact Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-contact.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Block No.1',
				'id'   => $prefix . 'contactaddresspage',
				'type' => 'title'
			),
			array(
				'name' => 'Address',
				'desc' => 'Insert the address',
				'id'   => $prefix . 'contactaddress',
				'std'  => '11 Fifth Ave, Loftus - NEW JERSEY, US',
				'type' => 'text'
			),
			array(
				'name' => 'Telephone',
				'desc' => 'Insert the telephone',
				'id'   => $prefix . 'contacttelephone',
				'std'  => '+ 61 (2) 8093 3400',
				'type' => 'text'
			),
			array(
				'name' => 'Fax',
				'desc' => 'Insert the fax',
				'id'   => $prefix . 'contactfax',
				'std'  => '+61 (2) 9542 3599',
				'type' => 'text'
			),
			array(
				'name' => 'Email',
				'desc' => 'Insert the email address',
				'id'   => $prefix . 'contactemail',
				'std'  => 'submissions@domain.com',
				'type' => 'text'
			),
			array(
				'name' => 'Block No.2',
				'id'   => $prefix . 'contacblock2',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'contacblock2title',
				'std'  => 'Questions?',
				'type' => 'text'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'contacblock2text',
				'std'  => 'Cras mattis consectetur purus sit amet fermentum. Cras justo odio ibus ac facilisis in, egestas eget quam. Maecenas sed diam eget risus.',
				'type' => 'textarea'
			),
			array(
				'name' => 'Link',
				'desc' => 'Insert the fax',
				'id'   => $prefix . 'contacblock2link',
				'std'  => 'https://www.google.com',
				'type' => 'text'
			),
			array(
				'name' => 'Text of the link',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'contacblock2linktext',
				'std'  => 'Read more',
				'type' => 'text'
			),
			array(
				'name' => 'Block No.3',
				'id'   => $prefix . 'contacblock3',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'contacblock3title',
				'std'  => 'Arizona',
				'type' => 'text'
			),
			array(
				'name' => 'Address',
				'desc' => 'Insert the address',
				'id'   => $prefix . 'contacblock3address',
				'std'  => '21 Fifth Ave, Loftus - Arizona, US',
				'type' => 'text'
			),
			array(
				'name' => 'Telephone',
				'desc' => 'Insert the telephone',
				'id'   => $prefix . 'contacblock3telephone',
				'std'  => '+ 61 (2) 8093 3400',
				'type' => 'text'
			),
			array(
				'name' => 'Fax',
				'desc' => 'Insert the fax',
				'id'   => $prefix . 'contacblock3fax',
				'std'  => '+61 (2) 9542 3599',
				'type' => 'text'
			),
			array(
				'name' => 'Email',
				'desc' => 'Insert the email address',
				'id'   => $prefix . 'contacblock3email',
				'std'  => 'submissions@domain.com',
				'type' => 'text'
			),
			array(
				'name' => 'Block No.4',
				'id'   => $prefix . 'contacblock4',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'contacblock4title',
				'std'  => 'Mexico',
				'type' => 'text'
			),
			array(
				'name' => 'Address',
				'desc' => 'Insert the address',
				'id'   => $prefix . 'contacblock4address',
				'std'  => '21 Fifth Ave, Loftus - Mexiko, US',
				'type' => 'text'
			),
			array(
				'name' => 'Telephone',
				'desc' => 'Insert the telephone',
				'id'   => $prefix . 'contacblock4telephone',
				'std'  => '+ 61 (2) 8093 3400',
				'type' => 'text'
			),
			array(
				'name' => 'Fax',
				'desc' => 'Insert the fax',
				'id'   => $prefix . 'contacblock4fax',
				'std'  => '+61 (2) 9542 3599',
				'type' => 'text'
			),
			array(
				'name' => 'Email',
				'desc' => 'Insert the email address',
				'id'   => $prefix . 'contacblock4email',
				'std'  => 'submissions@domain.com',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'admission_page_metabox',
		'title'      => 'Admission Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-admission.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on Admission page',
				'desc' => '',
				'id'   => $prefix . 'displayadmission',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The List Box?',
				'desc' => 'Select enable to show the List box',
				'id'   => $prefix . 'displayadmissionlist',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Accordion Box?',
				'desc' => 'Select enable to show the Accordion box',
				'id'   => $prefix . 'displayadmissionaccordion',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Comments Box?',
				'desc' => 'Select enable to show the Comments box',
				'id'   => $prefix . 'displayadmissioncomments',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Tabs Box?',
				'desc' => 'Select enable to show the Tabs box',
				'id'   => $prefix . 'displayadmissiontabs',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 677x308px',
				'id'   => $prefix . 'admissionimage',
				'std'  => '',
				'type' => 'file'
			),
			array(
				'name' => 'Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissiontext',
				'std'  => 'Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools.',
				'type' => 'textarea'
			),
			array(
				'name' => 'List',
				'id'   => $prefix . 'list',
				'type' => 'title'
			),
			array(
				'name' => 'No.1 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissionlist1',
				'std'  => 'God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan.',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissionlist2',
				'std'  => 'Evangel journey, doesn’t have to be filled with the confusioncost associated with applying to other schools.',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissionlist3',
				'std'  => 'Evangel has clear steps in place, backed by dedicated admissions counselors and financial aid representatives',
				'type' => 'text'
			),
			array(
				'name' => 'Accordion',
				'id'   => $prefix . 'accordion',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'admissionaccordiontitle',
				'std'  => 'Normal Accordion Without icons',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'admissionaccordiontitle1',
				'std'  => 'Accordion Panel #1',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissionaccordiontext1',
				'std'  => 'Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools. Evangel has clear steps in place, backed by dedicated admissions counselors and financial aid representatives, to see you through from start to finish. Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools.',
				'type' => 'textarea'
			),
			array(
				'name' => 'No.2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'admissionaccordiontitle2',
				'std'  => 'Accordion Panel #2',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissionaccordiontext2',
				'std'  => 'Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools. Evangel has clear steps in place, backed by dedicated admissions counselors and financial aid representatives, to see you through from start to finish. Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools.',
				'type' => 'textarea'
			),
			array(
				'name' => 'No.3 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'admissionaccordiontitle3',
				'std'  => 'Accordion Panel #3',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissionaccordiontext3',
				'std'  => 'Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools. Evangel has clear steps in place, backed by dedicated admissions counselors and financial aid representatives, to see you through from start to finish. Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools.',
				'type' => 'textarea'
			),
			array(
				'name' => 'No.4 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'admissionaccordiontitle4',
				'std'  => 'Accordion Panel #4',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissionaccordiontext4',
				'std'  => 'Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools. Evangel has clear steps in place, backed by dedicated admissions counselors and financial aid representatives, to see you through from start to finish. Choosing a university is a big step – one that will change the rest of your life. God has a plan for you, and Evangel is a place where you can be trained and equipped for that plan. Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools.',
				'type' => 'textarea'
			),
			array(
				'name' => 'Tabs',
				'id'   => $prefix . 'tabs',
				'type' => 'title'
			),
			array(
				'name' => 'No.1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'admissiontabstitle1',
				'std'  => 'No Icon Tab #1',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissiontabstext1',
				'std'  => '1 Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools.',
				'type' => 'textarea'
			),
			array(
				'name' => 'No.2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'admissiontabstitle2',
				'std'  => 'No Icon Tab #2',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissiontabstext2',
				'std'  => '2 Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools.',
				'type' => 'textarea'
			),
			array(
				'name' => 'No.3 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'admissiontabstitle3',
				'std'  => 'No Icon Tab #1',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'admissiontabstext3',
				'std'  => '3 Admissions, the start of your Evangel journey, doesn’t have to be filled with the confusion, frustration or cost associated with applying to other schools.',
				'type' => 'textarea'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'library_page_metabox',
		'title'      => 'Library Page Options',
		'pages'      => array( 'library', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Author',
				'desc' => 'Insert the Name',
				'id'   => $prefix . 'libraryauthor',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Search Title',
				'desc' => 'Insert the title for search form',
				'id'   => $prefix . 'searchtitle',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Year',
				'desc' => 'Insert the Year. Example: 1980',
				'id'   => $prefix . 'libraryyear',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Show in slider',
				'desc' => 'Select enable to show the Slider on template home 5',
				'id'   => $prefix . 'libraryslider',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'members_page_metabox',
		'title'      => 'Members Page Options',
		'pages'      => array( 'members', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Post',
				'desc' => 'Insert the post',
				'id'   => $prefix . 'memberspost',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Short desription',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'membersdesc',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Social links',
				'desc' => '',
				'id'   => $prefix . 'memberssocial',
				'type'    => 'title',
			),
			array(
				'name' => 'Twitter',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'memberssocialtwi',
				'std'  => 'https://twitter.com/',
				'type' => 'text'
			),
			array(
				'name' => 'Facebook',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'memberssocialfb',
				'std'  => 'https://www.facebook.com',
				'type' => 'text'
			),
			array(
				'name' => 'Linkedin',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'memberssocialin',
				'std'  => 'https://www.linkedin.com/',
				'type' => 'text'
			),
			array(
				'name' => 'Instagram',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'memberssocialinst',
				'std'  => 'https://instagram.com',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'testimonials_page_metabox',
		'title'      => 'Testimonials Page Options',
		'pages'      => array( 'testimonials', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Course',
				'desc' => 'Insert the course name',
				'id'   => $prefix . 'testimonialscourse',
				'std'  => '',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'events_page_metabox',
		'title'      => 'Events Page Options',
		'pages'      => array( 'events', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Start time',
				'desc' => 'Insert the date of event. Example: 19:00:00',
				'id'   => $prefix . 'eventstime1',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'End time events',
				'desc' => 'Insert the date of event. Example: 20:00:00',
				'id'   => $prefix . 'eventstime2',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Date',
				'desc' => 'Insert the date of event. Example: 8 September 2015',
				'id'   => $prefix . 'eventsdate',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Address',
				'desc' => 'Insert the address',
				'id'   => $prefix . 'eventsaddress',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Slider Image',
				'desc' => 'Insert an image if you want to show this event in slider. Recommended size - 1920px-630px',
				'id'   => $prefix . 'eventssliderimage',
				'std'  => '',
				'type' => 'file'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'gallery_page_metabox',
		'title'      => 'Gallery Page Options',
		'pages'      => array( 'gallery', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Show The gallery in home slider?',
				'desc' => 'Select enable to show gallery on home page',
				'id'   => $prefix . 'galleryslider',
				'std'  => 'off',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Disable', 'value' => 'off', ),
					array( 'name' => 'Enable', 'value' => 'on', ),
				),
			),
			array(
				'name' => 'Slider preview',
				'desc' => 'Insert an image for sldier preview. Recommended size: 1920-590px',
				'id'   => $prefix . 'gallerysliderpreview',
				'std'  => '',
				'type' => 'file'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'departmens_page_metabox',
		'title'      => 'Departmens Page Options',
		'pages'      => array( 'departmens', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'departmensdesc',
				'std'  => '',
				'type' => 'textarea'
			),
			array(
				'name' => 'Show The icon of the post?',
				'desc' => 'Select icon',
				'id'   => $prefix . 'departmensicon',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'academics_page_metabox',
		'title'      => 'Academics Page Options',
		'pages'      => array( 'academics', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'fields' => array(
			array(
				'name' => 'Post',
				'desc' => 'Insert the post',
				'id'   => $prefix . 'academicsspost',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'academicsdesc',
				'std'  => '',
				'type' => 'text'
			),
			array(
				'name' => 'Show This post on departments single page?',
				'desc' => 'Select enable to show this post single page',
				'id'   => $prefix . 'academicsslider',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Social links',
				'desc' => '',
				'id'   => $prefix . 'academicssocial',
				'type'    => 'title',
			),
			array(
				'name' => 'Twitter',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'academicssocialtwi',
				'std'  => 'https://twitter.com/',
				'type' => 'text'
			),
			array(
				'name' => 'Facebook',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'academicssocialfb',
				'std'  => 'https://www.facebook.com',
				'type' => 'text'
			),
			array(
				'name' => 'Linkedin',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'academicssocialin',
				'std'  => 'https://www.linkedin.com/',
				'type' => 'text'
			),
			array(
				'name' => 'Instagram',
				'desc' => 'Insert the link',
				'id'   => $prefix . 'academicssocialinst',
				'std'  => 'https://instagram.com',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'service_page_metabox',
		'title'      => 'Service Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-service.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Display or hide Boxes on About page',
				'desc' => '',
				'id'   => $prefix . 'displayabout',
				'type'    => 'title',
			),
			array(
				'name' => 'Show The Information Box?',
				'desc' => 'Select enable to show the Information box',
				'id'   => $prefix . 'displayserviceinfo',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Description Box?',
				'desc' => 'Select enable to show the Description box',
				'id'   => $prefix . 'displayservicedesc',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Teachers Box?',
				'desc' => 'Select enable to show the Teachers box',
				'id'   => $prefix . 'displayservicepeople',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The Courses Box?',
				'desc' => 'Select enable to show the Courses box',
				'id'   => $prefix . 'displayservicecourses',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Show The "What we can do" Box?',
				'desc' => 'Select enable to show the "What we can do" box',
				'id'   => $prefix . 'displayservicewhatdo',
				'std'  => 'on',
				'type'    => 'select',
				'options' => array(
					array( 'name' => 'Enable', 'value' => 'on', ),
					array( 'name' => 'Disable', 'value' => 'off', ),
				),
			),
			array(
				'name' => 'Information',
				'id'   => $prefix . 'serviceinfo',
				'type' => 'title'
			),
			array(
				'name' => 'Background',
				'desc' => 'Upload an image. Size: 1920x300px',
				'id'   => $prefix . 'serviceinfobg',
				'type' => 'file'
			),
			array(
				'name' => 'No.1 Icon',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'serviceinfoicon1',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'serviceinfotitle1',
				'std'  => 'Fiction',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'serviceinfotext1',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Icon',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'serviceinfoicon2',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'serviceinfotitle2',
				'std'  => 'Classic',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'serviceinfotext2',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Icon',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'serviceinfoicon3',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.3 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'serviceinfotitle3',
				'std'  => 'Nonfiction',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'serviceinfotext3',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Icon',
				'desc' => 'Select the icon',
				'id'   => $prefix . 'serviceinfoicon4',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.4 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'serviceinfotitle4',
				'std'  => 'For students',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Text',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'serviceinfotext4',
				'std'  => 'Wilderness School is grounded in values of a non-denominational Christian family tradition.',
				'type' => 'text'
			),
			array(
				'name' => 'Description',
				'id'   => $prefix . 'servicedesc',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicedesctitle',
				'std'  => 'Services you looking for',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 563x282px',
				'id'   => $prefix . 'servicedescimage',
				'type' => 'file'
			),
			array(
				'name' => 'Our teachers',
				'id'   => $prefix . 'servicepeople',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicepeopletitle',
				'std'  => 'Our best teachers',
				'type' => 'text'
			),
			array(
				'name' => 'Items count',
				'desc' => 'Insert the count',
				'id'   => $prefix . 'servicepeoplecount',
				'std'  => '6',
				'type' => 'text'
			),
			array(
				'name' => 'Courses',
				'id'   => $prefix . 'servicecourses',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicecoursestitle',
				'std'  => 'Our courses',
				'type' => 'text'
			),
			array(
				'name' => 'Image',
				'desc' => 'Upload an image. Size: 1920x530px',
				'id'   => $prefix . 'servicecoursesimage',
				'type' => 'file'
			),
			array(
				'name' => 'What we can do',
				'id'   => $prefix . 'servicewhatdo',
				'type' => 'title'
			),
			array(
				'name' => 'Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicewhatdotitle',
				'std'  => 'What we can do',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Show The icon',
				'desc' => 'Select icon',
				'id'   => $prefix . 'servicewhatdoicon1',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.1 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicewhatdotitle1',
				'std'  => 'Lorem Ipsum',
				'type' => 'text'
			),
			array(
				'name' => 'No.1 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'servicewhatdodesc1',
				'std'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Show The icon',
				'desc' => 'Select icon',
				'id'   => $prefix . 'servicewhatdoicon2',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.2 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicewhatdotitle2',
				'std'  => 'Lorem Ipsum',
				'type' => 'text'
			),
			array(
				'name' => 'No.2 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'servicewhatdodesc2',
				'std'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Show The icon',
				'desc' => 'Select icon',
				'id'   => $prefix . 'servicewhatdoicon3',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.3 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicewhatdotitle3',
				'std'  => 'Lorem Ipsum',
				'type' => 'text'
			),
			array(
				'name' => 'No.3 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'servicewhatdodesc3',
				'std'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Show The icon',
				'desc' => 'Select icon',
				'id'   => $prefix . 'servicewhatdoicon4',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.4 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicewhatdotitle4',
				'std'  => 'Lorem Ipsum',
				'type' => 'text'
			),
			array(
				'name' => 'No.4 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'servicewhatdodesc4',
				'std'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form',
				'type' => 'text'
			),
			array(
				'name' => 'No.5 Show The icon',
				'desc' => 'Select icon',
				'id'   => $prefix . 'servicewhatdoicon5',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.5 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicewhatdotitle5',
				'std'  => 'Lorem Ipsum',
				'type' => 'text'
			),
			array(
				'name' => 'No.5 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'servicewhatdodesc5',
				'std'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form',
				'type' => 'text'
			),
			array(
				'name' => 'No.6 Show The icon',
				'desc' => 'Select icon',
				'id'   => $prefix . 'servicewhatdoicon6',
				'std'  => '',
				'type'    => 'select',
				'options' => $font_awesome
			),
			array(
				'name' => 'No.6 Title',
				'desc' => 'Insert the title',
				'id'   => $prefix . 'servicewhatdotitle6',
				'std'  => 'Lorem Ipsum',
				'type' => 'text'
			),
			array(
				'name' => 'No.6 Description',
				'desc' => 'Insert the text',
				'id'   => $prefix . 'servicewhatdodesc6',
				'std'  => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'blog_page_metabox',
		'title'      => 'Blog Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-blog-1.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of posts',
				'id'   => $prefix . 'blog1count',
				'std'  => '6',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'blog_page_metabox',
		'title'      => 'Blog Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-blog-2.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of posts',
				'id'   => $prefix . 'blog2count',
				'std'  => '6',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'gallery_page_metabox',
		'title'      => 'Gallery Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-gallery-1.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of posts',
				'id'   => $prefix . 'gallery1count',
				'std'  => '14',
				'type' => 'text'
			),
		)
	);

	$meta_boxes[] = array(
		'id'         => 'gallery_page_metabox',
		'title'      => 'Gallery Page Options',
		'pages'      => array( 'page', ), // Post type
		'context'    => 'normal',
		'priority'   => 'high',
		'show_names' => true, // Show field names on the left
		'show_on'    => array( 'key' => 'page-template', 'value' => array('template-gallery-2.php'), ), // Specific post templates to display this metabox
		'fields' => array(
			array(
				'name' => 'Count',
				'desc' => 'Insert the count of posts',
				'id'   => $prefix . 'gallery2count',
				'std'  => '6',
				'type' => 'text'
			),
		)
	);

	return $meta_boxes;
}

/**
 * Get image sizes for images
 * 
 * @return array
 */
function aletheme_get_images_sizes() {
	return array(

		'gallery' => array(
			array(
				'name'      => 'gallery-single',
				'width'     => 678,
				'height'    => 316,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-thumba',
				'width'     => 220,
				'height'    => 194,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-thumbaone',
				'width'     => 170,
				'height'    => 92,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-thumbatwo',
				'width'     => 170,
				'height'    => 168,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-thumbathree',
				'width'     => 170,
				'height'    => 198,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-thumbafour',
				'width'     => 170,
				'height'    => 240,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-home31',
				'width'     => 484,
				'height'    => 242,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-home32',
				'width'     => 242,
				'height'    => 242,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-home33',
				'width'     => 484,
				'height'    => 484,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-home4',
				'width'     => 1920,
				'height'    => 590,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-home41',
				'width'     => 480,
				'height'    => 193,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-one1',
				'width'     => 216,
				'height'    => 234,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-one2',
				'width'     => 432,
				'height'    => 234,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-one3',
				'width'     => 432,
				'height'    => 468,
				'crop'      => true,
			),
			array(
				'name'      => 'gallery-two1',
				'width'     => 411,
				'height'    => 516,
				'crop'      => true,
			),
		),
		'post' => array(
			array(
				'name'      => 'post-single',
				'width'     => 678,
				'height'    => 316,
				'crop'      => true,
			),
			array(
				'name'      => 'post-recent',
				'width'     => 145,
				'height'    => 134,
				'crop'      => true,
			),
			array(
				'name'      => 'post-home2',
				'width'     => 320,
				'height'    => 168,
				'crop'      => true,
			),
			array(
				'name'      => 'post-archive1',
				'width'     => 323,
				'height'    => 318,
				'crop'      => true,
			),
		),
		'news' => array(
			array(
				'name'      => 'news-single',
				'width'     => 678,
				'height'    => 316,
				'crop'      => true,
			),
			array(
				'name'      => 'news-thumba',
				'width'     => 145,
				'height'    => 134,
				'crop'      => true,
			),
			array(
				'name'      => 'news-home4',
				'width'     => 343,
				'height'    => 172,
				'crop'      => true,
			),
		),
		'academics' => array(
			array(
				'name'      => 'academics-single',
				'width'     => 678,
				'height'    => 316,
				'crop'      => true,
			),
			array(
				'name'      => 'academics-thumba',
				'width'     => 244,
				'height'    => 214,
				'crop'      => true,
			),
			array(
				'name'      => 'academics-mini',
				'width'     => 150,
				'height'    => 152,
				'crop'      => true,
			),
			array(
				'name'      => 'academics-service',
				'width'     => 65,
				'height'    => 65,
				'crop'      => true,
			),
		),
		'course' => array(
			array(
				'name'      => 'course-single',
				'width'     => 678,
				'height'    => 316,
				'crop'      => true,
			),
			array(
				'name'      => 'course-image',
				'width'     => 1920,
				'height'    => 125,
				'crop'      => true,
			),
			array(
				'name'      => 'course-thumba',
				'width'     => 250,
				'height'    => 205,
				'crop'      => true,
			),
			array(
				'name'      => 'course-home2',
				'width'     => 256,
				'height'    => 167,
				'crop'      => true,
			),
			array(
				'name'      => 'course-home5',
				'width'     => 422,
				'height'    => 423,
				'crop'      => true,
			),
			array(
				'name'      => 'course-selected',
				'width'     => 308,
				'height'    => 177,
				'crop'      => true,
			),
		),
		'events' => array(
			array(
				'name'      => 'events-single',
				'width'     => 678,
				'height'    => 316,
				'crop'      => true,
			),
			array(
				'name'      => 'events-archive',
				'width'     => 509,
				'height'    => 304,
				'crop'      => true,
			),
			array(
				'name'      => 'events-single',
				'width'     => 1080,
				'height'    => 304,
				'crop'      => true,
			),
		),
		'product' => array(
			array(
				'name'      => 'product-thumba',
				'width'     => 336,
				'height'    => 401,
				'crop'      => true,
			),
			array(
				'name'      => 'product-single',
				'width'     => 517,
				'height'    => 517,
				'crop'      => true,
			),
			array(
				'name'      => 'product-mini',
				'width'     => 159,
				'height'    => 159,
				'crop'      => true,
			),
		),
		'members' => array(
			array(
				'name'      => 'members-home1',
				'width'     => 65,
				'height'    => 65,
				'crop'      => true,
			),
			array(
				'name'      => 'members-home3',
				'width'     => 371,
				'height'    => 509,
				'crop'      => true,
			),
			array(
				'name'      => 'members-archive',
				'width'     => 243,
				'height'    => 215,
				'crop'      => true,
			),
			array(
				'name'      => 'members-single',
				'width'     => 280,
				'height'    => 265,
				'crop'      => true,
			),
		),
		'library' => array(
			array(
				'name'      => 'library-single',
				'width'     => 678,
				'height'    => 316,
				'crop'      => true,
			),
			array(
				'name'      => 'library-home2',
				'width'     => 529,
				'height'    => 216,
				'crop'      => true,
			),
			array(
				'name'      => 'library-home5',
				'width'     => 1920,
				'height'    => 592,
				'crop'      => true,
			),
		),
		'testimonials' => array(
			array(
				'name'      => 'testimonials-home3',
				'width'     => 78,
				'height'    => 78,
				'crop'      => true,
			),
			array(
				'name'      => 'testimonials-single',
				'width'     => 678,
				'height'    => 316,
				'crop'      => true,
			),
		),
		'departmens' => array(
			array(
				'name'      => 'departmens-archive',
				'width'     => 341,
				'height'    => 244,
				'crop'      => true,
			),
			array(
				'name'      => 'departmens-thumba',
				'width'     => 1064,
				'height'    => 448,
				'crop'      => true,
			),
		),
	);
}

/**
 * Add post types that are used in the theme 
 * 
 * @return array
 */
function aletheme_get_post_types() {
	return array(
		'gallery' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 20,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail',
					'comments',
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'Gallery',
			'multiple' => 'Galleries',
			'columns'    => array(
				'first_image',
			)
		),
		'course' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 21,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail',
					'comments',
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'Course',
			'multiple' => 'Course',
			'columns'    => array(
				'first_image',
			)
		),
		'events' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 22,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail',
					'comments',
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'Event',
			'multiple' => 'Events',
			'columns'    => array(
				'first_image',
			)
		),
		'news' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 23,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail',
					'comments',
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'News',
			'multiple' => 'News',
			'columns'    => array(
				'first_image',
			)
		),
		'academics' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 24,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail',
					'comments',
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'Academic',
			'multiple' => 'Academics',
			'columns'    => array(
				'first_image',
			)
		),
		'library' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 24,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail',
					'comments',
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'Library',
			'multiple' => 'Library',
			'columns'    => array(
				'first_image',
			)
		),
		'members' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 24,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail'
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'Member',
			'multiple' => 'Members',
			'columns'    => array(
				'first_image',
			)
		),
		'testimonials' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 24,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail',
					'comments'
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'Testimonial',
			'multiple' => 'Testimonials',
			'columns'    => array(
				'first_image',
			)
		),
		'departmens' => array(
			'config' => array(
				'public' => true,
				'menu_position' => 24,
				'has_archive'   => true,
				'supports'=> array(
					'title',
					'editor',
					'thumbnail'
				),
				'show_in_nav_menus'=> true,
			),
			'singular' => 'Departmen',
			'multiple' => 'Departmens',
			'columns'    => array(
				'first_image',
			)
		),
	);
}

/**
 * Add taxonomies that are used in theme
 * 
 * @return array
 */
function aletheme_get_taxonomies() {
	return array(
		'gallery-category'    => array(
			'for'        => array('gallery'),
			'config'    => array(
				'sort'        => true,
				'args'        => array('orderby' => 'term_order'),
				'hierarchical' => true,
			),
			'singular'    => 'Gallery Category',
			'multiple'    => 'Gallery Categories',
		),
		'course-category'    => array(
			'for'        => array('course'),
			'config'    => array(
				'sort'        => true,
				'args'        => array('orderby' => 'term_order'),
				'hierarchical' => true,
			),
			'singular'    => 'Course Category',
			'multiple'    => 'Course Categories',
		),
		'course-category'    => array(
			'for'        => array('course'),
			'config'    => array(
				'sort'        => true,
				'args'        => array('orderby' => 'term_order'),
				'hierarchical' => true,
			),
			'singular'    => 'Course Tag',
			'multiple'    => 'Course Tag',
		),
		'library-category'    => array(
			'for'        => array('library'),
			'config'    => array(
				'sort'        => true,
				'args'        => array('orderby' => 'term_order'),
				'hierarchical' => true,
			),
			'singular'    => 'Genre',
			'multiple'    => 'Genres',
		),
	);
}

/**
 * Add post formats that are used in theme
 * 
 * @return array
 */
function aletheme_get_post_formats() {
	return array();
}

/**
 * Get sidebars list
 * 
 * @return array
 */
function aletheme_get_sidebars() {
	$sidebars = array();
	return $sidebars;
}

/**
 * Predefine custom sliders
 * @return array
 */
function aletheme_get_sliders() {
	return array(
		'sneak-peek' => array(
			'title'		=> 'Sneak Peek',
		),
	);
}

/**
 * Post types where metaboxes should show
 * 
 * @return array
 */
function aletheme_get_post_types_with_gallery() {
	return array('gallery', 'post', 'departmens','events','course');
}

/**
 * Add custom fields for media attachments
 * @return array
 */
function aletheme_media_custom_fields() {
	return array();
}