<?php
/**
 * Template Name: Template Reservations
 */
if (isset($_POST['contact'])) {
	$error = ale_send_contact($_POST['contact']);
}
get_header(); ?>
	<div class="wrapper cf white-dark-bg">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e("Reservation","aletheme"); ?></span>

				<?php echo get_breadcrumbs(); ?>
			</div>
		</div>

		<section class="reservation-text wrapper-inside">
			<h2>
				<?php if(ale_get_meta("title_p_reservation")) {
					echo esc_attr(ale_get_meta("title_p_reservation"));
				} ?>
			</h2>

			<div class="story">
				<?php if (have_posts()) : while (have_posts()) : the_post();
					the_content();
				endwhile; endif; ?>
			</div>
		</section>
	</div>

	<?php ale_part('filter'); ?>

	<div class="wrapper cf white-dark-bg">
		<?php
		$number = ale_get_option('reservation_listing_num');
		$query = new WP_Query(
			array(
				'posts_per_page' => $number,
				'post_type' => 'listing'
			)
		);
		if ($query->have_posts()) : ?>
			<div class="reservation-listing scroll-pane">
				<div class="scroll cf">
					<?php while ($query->have_posts()) : $query->the_post(); ?>
						<article class="left item">
							<?php if (get_the_post_thumbnail($post->ID,'listing-gallery2')){
								echo get_the_post_thumbnail($post->ID,'listing-gallery2');
							} else {
								echo '<img src="http://placehold.it/170x170" alt>';
							} ?>

							<div class="text">
								<h2<?php if($listing_count == 2){echo' class="left"';} ?>>
									<?php $current_category = wp_get_post_terms($post->ID, 'brand-listing', array("fields" => "all"));
									if($current_category){
										foreach($current_category as $curcat){
											echo '<span>' . $curcat->name . '</span> ';
										}
									}
									the_title(); ?>
								</h2>
							</div>

							<a href="<?php the_permalink(); ?>">
								<i class="fa fa-check"></i>
							</a>
						</article>
					<?php endwhile; ?>
				</div>
			</div>
		<?php endif; wp_reset_postdata();?>

		<div class="wrapper-inside reservation-form">
			<?php if (isset($_GET['success'])) : ?>
				<p class="success"><?php _e('Thank you for your message!', 'aletheme')?></p>
			<?php endif; ?>
			<?php if (isset($error) && isset($error['msg'])) : ?>
				<p class="error"><?php echo esc_attr($error['msg']);?></p>
			<?php endif; ?>
			<form method="post" id="contact-form">
				<input class="name" name="contact[name]" type="text" placeholder="Name" value="<?php echo isset($_POST['contact']['name']) ? $_POST['contact']['name'] : ''?>" required="required" id="reservation-form-name" />

				<input class="phone" name="contact[phone]" type="text" placeholder="Phone" value="<?php echo isset($_POST['contact']['phone']) ? $_POST['contact']['phone'] : ''?>" id="contact-form-phone" />

				<div class="input">
					<span class="span_rez"><i class="fa fa-angle-down"></i></span>
					<input class="date" name="contact[date]" type="text" placeholder="Date" value="<?php echo isset($_POST['contact']['date']) ? $_POST['contact']['date'] : ''?>" id="contact-form-date" />
				</div>

				<input class="time" name="contact[time]" type="text" placeholder="Time" value="<?php echo isset($_POST['contact']['time']) ? $_POST['contact']['time'] : ''?>" id="contact-form-time" />


				<textarea class="notes" name="contact[message]"  placeholder="Notes..." id="contact-form-message" required="required"><?php echo isset($_POST['contact']['message']) ? $_POST['contact']['message'] : ''?></textarea>
				<div class="submit grey-submit-light-bg red-bg-hover">
					<i class="fa fa-check f_reserv"></i>
					<input class="submit_rez" type="submit" value="Make a reservation"/>
				</div>

				<p>
					<?php
					if(ale_get_meta("text_reservation_bottom")) {
						echo esc_attr(ale_get_meta("text_reservation_bottom"));
					}
					?>
				</p>
				<?php wp_nonce_field() ?>
			</form>
		</div>
	</div>
<?php get_footer(); ?>