<?php

/**
 * Template Name: Template Gallery 1
 */
get_header();
?>
<div class="wrapper white-dark-bg cf">
	<div class="page-header">
		<div class="wrapper-inside cf">
			<span class="page-name left"><?php _e('Gallery', 'aletheme'); ?></span>

			<?php echo get_breadcrumbs(); ?>
		</div>
	</div>

	<div class="wrapper-inside typical-page page-template-gallery-1">
		<div class="content_box left">
			<div class="isotope-gutter">
				<div class="gutter"></div>
				<?php
				if ( get_query_var('paged') ) $paged = get_query_var('paged');
				if ( get_query_var('page') ) $paged = get_query_var('page');
				$number = intval(ale_get_option('gallery_num_1'));
				$query_gallery = new WP_Query(
					array(
						'post_type' => 'gallery',
						'paged'=>$paged,
						'posts_per_page' => $number
					)
				);
				if( $query_gallery->have_posts() ): while( $query_gallery->have_posts() ) : $query_gallery->the_post(); ?>
					<article <?php post_class('item left cf'); ?>>
						<div class="image" >
							<a href="<?php the_permalink(); ?>">
								<?php if( get_the_post_thumbnail($post->ID,'gallery-style1')) {
									echo get_the_post_thumbnail($post->ID,'gallery-style1');
								} else {
									echo '<img class="non_image" src="http://placehold.it/334x271&amp;text=No+image" alt/>';
								} ?>
							</a>
						</div>

						<div class="text left">
							<h2>
								<a href="<?php the_permalink(); ?>"  class="black-col red-col-hover">
									<?php echo get_the_title(); ?>
								</a>
							</h2>

							<div class="details">
								<?php
								the_time('j F Y');
								echo "&nbsp;&nbsp;" ; echo "/";
								echo "&nbsp;&nbsp;";
								$attachments = get_children(array('post_parent'=>$post->ID));
								$counter=count($attachments);
								echo esc_attr($counter);
								echo "&nbsp;";
								echo _e('pictures','aletheme');
								?>
							</div>
						</div>

						<div class="like left">
							<?php if( function_exists('dot_irecommendthis') ){
								dot_irecommendthis();
							} ?>
						</div>
					</article>
				<?php endwhile; endif; wp_reset_postdata(); ?>
			</div>

			<?php echo  ale_custom_page_links($query_gallery); ?>
		</div>

		<?php if ( is_active_sidebar( 'gallery-sidebar' ) ) { ?>
		<aside class="sidebar left cf">
			<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('gallery-sidebar') ) : endif; ?>
		</aside>
		<?php } ?>
	</div>
</div>
<?php get_footer(); ?>
