<?php add_action('wp_head','ajaxurl');
function ajaxurl() {
	?>
	<script type="text/javascript">
		var ajaxurl = '<?php echo admin_url('admin-ajax.php'); ?>';
	</script>
<?php
}
get_header(); ?>
	<div class="wrapper white-dark-bg">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php echo single_cat_title("", false); ?></span>

				<?php echo get_breadcrumbs(); ?>
			</div>
		</div>

		<div class="wrapper-inside typical-page page-archive-special-offers cf">
			<div class="content_box left">
				<?php
				if ( get_query_var('paged') ) $paged = get_query_var('paged');
				if ( get_query_var('page') ) $paged = get_query_var('page');
				$number = intval(ale_get_option('special_affers_num'));
				if(isset($_POST['submit'])) {
					$args = array(
						'posts_per_page' => -1,
						'post_type' => 'special-offers',
						'paged' => $paged,
						'tax_query' => array(
							array(
								'taxonomy' => 'brand-offers',
								'field' => 'slug',
								'terms' => single_cat_title("", false)
							)
						),
						'meta_query' => array(
							'relation' => 'AND',
						)
					);
				}
				else {
					$args = array(
						'post_type' => 'special-offers',
						'paged' => $paged,
						'posts_per_page' => $number,
						'tax_query' => array(
							array(
								'taxonomy' => 'brand-offers',
								'field' => 'slug',
								'terms' => single_cat_title("", false)
							)
						),
						'meta_query' => array(
							'relation' => 'AND',
						)
					);
				}

				if(isset($_POST['min_price']))
				{
					$price_min=$_POST['min_price'];
				}
				if(isset($_POST['max_price'])) {
					$price_max=$_POST['max_price'];
				}

				if(isset($_POST['brand'])) {
					$brand=$_POST['brand'];
					array_push($args['tax_query'], array(
						'taxonomy' => 'brand-offers',
						'terms' => $brand
					));
				}
				if(isset($_POST['body-style'])) {
					$body_style=$_POST['body-style'];
					array_push($args['tax_query'], array(
						'taxonomy' => 'body-offers',
						'terms' => $body_style

					));
				}
				if(isset($_POST['transmission'])) {
					$transmission=$_POST['transmission'];
					array_push($args['tax_query'], array(
						'taxonomy' => 'transmission_car',
						'terms' => $transmission
					));
				}
				if(isset($_POST['min_year'])) {
					$min_year=$_POST['min_year'];
				}
				if(isset($_POST['max_year'])) {
					$max_year=$_POST['max_year'];
				}
				if(isset($_POST['min_mileage'])) {
					$min_mileage=$_POST['min_mileage'];

				}
				if(isset($_POST['max_mileage'])) {
					$max_mileage=$_POST['max_mileage'];
				}
				if(isset($price_min) && isset($price_max)){
					array_push($args['meta_query'],array(
						'key' => 'ale_price_car_offers',
						'value' => array( $price_min, $price_max ),
						'type' => 'numeric',
						'compare' => 'BETWEEN'
					));
				}
				if(isset($min_year) && isset($max_year)){
					$s=$max_year-$min_year+1;
					$a=array();
					for($i=1;$i<=$s;$i++) {
						array_push($a,$min_year);
						$min_year=$min_year+1;
					}
					array_push($args['tax_query'],array(
						'taxonomy' => 'year-offers',
						'field'    => 'name',
						'terms'    => $a,
						'operator' => 'IN',
					));
				}
				if(isset($min_mileage) && isset($max_mileage)) {

					array_push($args['meta_query'],array(
						'key' => 'ale_km_car',
						'value' => array( $min_mileage, $max_mileage),
						'type' => 'numeric',
						'compare' => 'BETWEEN'
					));

				}
				$query_special_offers = new WP_Query($args);
				if( $query_special_offers->have_posts() ): while( $query_special_offers->have_posts() ) : $query_special_offers->the_post(); ?>
					<article class="item cf">
						<div class="image left">
							<?php if(ale_get_meta("reduction_car")) { ?>
								<span class="reduction red-bg white-col">
								<?php echo esc_attr(ale_get_meta("reduction_car")). esc_attr('% ') . __('OFF', 'aletheme'); ?>
							</span>
							<?php } ?>

							<a href="<?php the_permalink(); ?>">
								<?php if(get_the_post_thumbnail($post->ID,'special-offers-img')) {
									echo get_the_post_thumbnail($post->ID,'special-offers-img');
								} else {
									echo "<img src='http://placehold.it/285x200&amp;text=No+image' alt>";
								} ?>
							</a>
						</div>

						<div class="text left">
							<h2>
								<a href="<?php the_permalink(); ?>" class="black-col red-col-hover">
									<?php $current_category = wp_get_post_terms($post->ID, 'brand-offers', array("fields" => "all"));
									if($current_category){
										foreach($current_category as $curcat){
											echo '<span>' . $curcat->name . '</span> ';
										}
									}
									the_title(); ?>
								</a>
							</h2>

							<div class="string">
								<?php echo ale_trim_excerpt(30); ?>
							</div>

							<div class="details">
								<?php if(ale_get_meta("km_car")) { ?>
									<span>
									<i class="fa fa-clock-o"></i>
										<?php echo esc_attr(ale_get_meta("km_car"))." ".__('KM', 'aletheme'); ?>
								</span>
								<?php } ?>

								<span class="date">
								<i class="fa fa-calendar"></i>
									<?php  the_time('M, j Y'); ?>
							</span>

								<?php if(ale_get_meta("price_car_offers")) {
									echo '<span class="price red-col">' . ale_get_option('curency') . esc_attr(ale_get_meta("price_car_offers")) . '</span>';
								} ?>
							</div>
						</div>
					</article>
				<?php endwhile; endif; wp_reset_postdata(); ?>
			</div>
<?php if ( is_active_sidebar( 'special_offers-sidebar' ) ) { ?>
			<aside class="sidebar left cf">
				<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('special_offers-sidebar') ) : endif; ?>
			</aside>
<?php } ?>
			<?php ale_custom_page_links($query_special_offers); ?>
		</div>
	</div>
<?php get_footer(); ?>