<?php
/*
  * Template name: Home
  * */
get_header(); ?>

	<!-- Slider -->
	<?php if(ale_get_meta("display_home_slider")!='off' && ale_get_meta("display_home_slider")!='') : ?>
		<?php wp_reset_postdata();
		$count = ale_get_meta('home_slider_num');
		$query_slider = new WP_Query(
			array(
				'posts_per_page' => $count,
				'post_type' => 'special-offers',
				'ignore_sticky_posts' => 1,
				'post__not_in' => get_option('sticky_posts'),
				'paged' => $paged,
				'meta_query' => array(
					array(
						'key' => 'ale_display_in_home_slider',
						'value' => 'on'
					)
				),
			)
		);
		if( $query_slider->have_posts() ): ?>
			<div class="home-slider">
				<div class="slider">
					<ul class="slides">
						<?php while( $query_slider->have_posts() ) : $query_slider->the_post(); ?>
							<li>
								<article>
									<h1 class="citroen_layer">
										<?php $current_category = wp_get_post_terms($post->ID, 'brand-offers', array("fields" => "all"));
										foreach($current_category as $cat){
											echo esc_attr($cat->name);
										} ?>
										<span><?php the_title(); ?></span>
									</h1>

									<div class="text">
										<?php if(get_the_post_thumbnail($post->ID,'special-offers-slider')) {
											echo get_the_post_thumbnail($post->ID,'special-offers-slider');
										} else {
											 echo '<img src="http://placehold.it/800x351&amp;text=No+image" alt/>';
										} ?>

										<div class="details cf">
											<div class="citroen_logo brown-bg red-bg-hover left">
												<a href="<?php the_permalink(); ?>" class="white-col">
													<?php $current_category = wp_get_post_terms($post->ID, 'brand-offers', array("fields" => "all"));
													foreach($current_category as $cat){
														echo esc_attr($cat->name);
													} ?>
													<span><?php the_title(); ?></span>
												</a>
											</div>

											<span class="car-price left">
												<?php if(ale_get_meta("price_car_offers")) {
													echo esc_attr(ale_get_option('curency')) . esc_attr(ale_get_meta('price_car_offers'));
												} ?>
											</span>
										</div>
									</div>
								</article>
							</li>
						<?php endwhile; ?>
					</ul>
				</div>
			</div> <!-- end style of container page -->
		<?php endif; wp_reset_postdata(); ?>
	<?php endif; ?>

	<!-- Filter -->
	<?php if(ale_get_meta('display_filter')!='off' && ale_get_meta('display_filter')!='') :
		ale_part('filter');
	endif; ?>

	<!-- Listing post type -->
	<?php if(ale_get_meta('display_listing')!='off' && ale_get_meta('display_listing')!='') : ?>
		<div class="wrapper white-dark-bg cf">
			<div class="home-listing wrapper-inside isotope cf">
				<?php wp_reset_postdata();
				$count_list = ale_get_meta('home_listing_num');
				$query_lising = new WP_Query(
					array(
						'posts_per_page' => $count_list,
						'post_type' => 'listing'
					)
				);
				$listing_count = 0;
				if ($query_lising->have_posts()) : while ($query_lising->have_posts()) : $query_lising->the_post();
					$listing_count++;
					if($listing_count == 2){
						$big = ' big';
					} else{
						$big = '';
					} ?>
					<article <?php post_class('item left' . $big); ?>>
						<?php if($listing_count == 2){
							if(get_the_post_thumbnail($post->ID,'listing-max')) {
								echo get_the_post_thumbnail($post->ID,'listing-max');
							} else {
								echo '<img src="http://placehold.it/490x255" alt>';
							}
						} else {
							if(get_the_post_thumbnail($post->ID,'listing-min')) {
								echo get_the_post_thumbnail($post->ID,'listing-min');
							} else {
								echo '<img src="http://placehold.it/245x255" alt>';
							}
						}?>

						<div class="text cf">
							<h2<?php if($listing_count == 2){echo' class="left"';} ?>>
								<?php $current_category = wp_get_post_terms($post->ID, 'brand-listing', array("fields" => "all"));
								if($current_category){
									foreach($current_category as $curcat){
									echo '<span>' . $curcat->name . '</span> ';
									}
								}
								the_title(); ?>
							</h2>

							<div class="details<?php if($listing_count == 2){echo' left';} ?>">
								<?php $current_category = wp_get_post_terms($post->ID, 'fuel-listing', array("fields" => "all"));
								if($current_category){
									echo '<p class="cf"><span class="caption left">' . __('Fuel','aletheme') . '</span>';
									foreach($current_category as $curcat){
										echo '<span class="right">' . $curcat->name . '</span>';
									}
									echo '</p>';
								}?>

								<?php $current_category = wp_get_post_terms($post->ID, 'year-listing', array("fields" => "all"));
								if($current_category){
									echo '<p class="cf"><span class="caption left">' . __('Year','aletheme') . '</span>';
									foreach($current_category as $curcat){
										echo '<span class="right">' . $curcat->name . '</span>';
									}
									echo '</p>';
								}?>

								<?php $current_category = wp_get_post_terms($post->ID, 'transmission-listing', array("fields" => "all"));
								if($current_category){
									echo '<p class="cf"><span class="caption left">' . __('Transmission','aletheme') . '</span>';
									foreach($current_category as $curcat){
										echo '<span class="right">' . $curcat->name . '</span>';
									}
									echo '</p>';
								}?>

								<?php if(ale_get_meta("location_car")){ ?>
									<p class="cf"><span class="caption left"><?php echo _e('Location','aletheme'); ?></span><span class="right"><?php echo esc_attr(ale_get_meta("location_car")); ?></span></p>
								<?php } ?>
							</div>

							<div class="information<?php if($listing_count == 2){echo' left';} ?>">
								<?php if(ale_get_meta('brakes_car')){ ?>
									<i class="fa fa-dot-circle-o grey-col"></i>
								<?php } ?>

								<?php if(ale_get_meta('transmission_icon_car')){ ?>
									<i class="fa fa-gavel grey-col"></i>
								<?php } ?>

								<?php if(ale_get_meta('oil_car')){ ?>
									<i class="fa fa-flask grey-col"></i>
								<?php } ?>

								<?php if(ale_get_meta('repair_car')){ ?>
									<i class="fa fa-wrench grey-col"></i>
								<?php } ?>
							</div>
						</div>

						<a href="<?php echo  the_permalink(); ?>"></a>
					</article>
				<?php endwhile; endif; wp_reset_postdata(); ?>
			</div>

			<div class="wrapper-inside show-more">
				<a href="<?php echo get_post_type_archive_link('listing');?>" class="grey-col red-col-hover"><?php _e('Show more', 'aletheme'); ?><i class="fa fa-angle-down red-bg white-col"></i></a>
			</div>
		</div>
	<?php endif; ?>

	<!-- Car description -->
	<?php if(ale_get_meta('display_image')!='off' && ale_get_meta('display_image')!='') : ?>
		<div class="home-description">
			<img src="<?php if(ale_get_meta("image_car")){
				echo esc_url(ale_get_meta("image_car"));
			} else {
				echo 'http://placehold.it/1920x900/&amp;text=No+Image';
			}?>" alt="">

			<h2>
				<?php echo ale_get_meta('title_car'); ?>
				<span><?php echo ale_get_meta('tip_car'); ?>
					<i><?php echo ale_get_meta('year_car'); ?></i>
				</span>
			</h2>

			<div class="details brown-bg cf">
				<div class="text right">
					<h3><?php echo _e('Details','aletheme'); ?></h3>
					<?php if(ale_get_meta("home_model")) { ?>
						<p><?php echo _e('Model, Body type:','aletheme'); ?><span>.............................<?php echo esc_attr(ale_get_meta("home_model")); ?></span></p>
					<?php } ?>

					<?php if(ale_get_meta("home_power")) { ?>
						<p><?php echo _e('Engine Power:','aletheme'); ?><span>..................................<?php echo esc_attr(ale_get_meta("home_power")); ?></span></p>
					<?php } ?>

					<?php if(ale_get_meta("home_transmission")) { ?>
						<p><?php echo _e('Transmission:','aletheme'); ?><span>...................................<?php echo esc_attr(ale_get_meta("home_transmission")); ?></span></p>
					<?php } ?>

					<?php if(ale_get_meta("home_emissions")) { ?>
						<p><?php echo _e('CO2-Emissions:','aletheme') ?><span>...............................<?php echo esc_attr(ale_get_meta("home_emissions")); ?></span></p>
					<?php } ?>

					<?php if(ale_get_meta("home_price")) {echo '<span class="price">' . ale_get_option('curency') . esc_attr(ale_get_meta("home_price")) . '</span>';} ?>
				</div>
			</div>
		</div>
	<?php endif; ?>

	<!-- Single Blog post -->
<?php if(ale_get_meta('display_singleblog')!='' && ale_get_meta('display_singleblog')!='off') { ?>
	<div class="wrapper white-dark-bg cf">
		<?php $query_blog = new WP_Query(
			array(
				'posts_per_page' => 1,
				'post_type' => 'post',
				'ignore_sticky_posts' => 1,
				'post__not_in' => get_option('sticky_posts'),
			)
		);
		if (($query_blog->have_posts()) && (ale_get_meta('display_image')!='off') ) : ?>
			<div class="wrapper-inside cf">
				<article <?php post_class('home-single-post right cf'); ?>>
					<?php while ($query_blog->have_posts()) : $query_blog->the_post(); ?>
						<h2 class="title"><a href="<?php echo the_permalink(); ?>" class="black-col red-col-hover"><?php the_title(); ?></a></h2>

						<div class="string">
							<?php echo ale_trim_excerpt(50); ?>
						</div>

						<a href="<?php echo the_permalink(); ?>" class="more grey-light-col red-col-hover"><i class="fa fa-angle-right white-col red-bg"></i><span><?php echo _e('Read more details!','aletheme'); ?></span></a>
					<?php endwhile; ?>
				</article>
			</div>
		<?php endif; wp_reset_postdata(); ?>
	</div>
<?php } ?>

<?php if(ale_get_meta('display_blog')!='off' && ale_get_meta('display_blog')!='') { ?>
	<!-- Blog, Brand, Personal -->
	<div class="wrapper white-dark-bg">
		<div class="wrapper-inside cf blog-brand-pesonal">
			<!-- Blog -->
			<?php wp_reset_postdata();
			$count = ale_get_meta_attr('home_blog_num');
			$query_blog = new WP_Query(
				array(
					'posts_per_page' => $count,
					'post_type' => 'post',
					'ignore_sticky_posts' => 1,
					'post__not_in' => get_option('sticky_posts')
				)
			);
			if ($query_blog->have_posts()) : ?>
				<section class="home-blog left">
					<h2><?php echo ale_get_meta_attr('home_blog_title'); ?><span><?php echo ale_get_meta_attr('home_blog_desc'); ?></span></h2>

					<div class="isotope-gutter cf">
						<div class="gutter"></div>

						<?php $blog_count = 0; while ($query_blog->have_posts()) : $query_blog->the_post();
							$blog_count++;
							if($blog_count == 2){
								$blog_style = ' rounded';
							} elseif($blog_count == 3){
								$blog_style = ' absolute';
							} else {
								$blog_style = '';
							} ?>
							<article <?php post_class('item left' . $blog_style); ?>>
								<?php if($blog_count == 2){
									echo '<div class="image"><a href="' . get_the_permalink() . '">';
										if(get_the_post_thumbnail($post->ID,'post-blog')) {
											echo get_the_post_thumbnail($post->ID,'post-blog');
										} else {
											echo "<img src='http://placehold.it/153x153&amp;text=No+image' alt>";
										}
									echo '</a></div>';
								} elseif($blog_count == 3){
									if(get_the_post_thumbnail($post->ID,'post-blog3')) {
										echo get_the_post_thumbnail($post->ID,'post-blog3');
									} else {
										echo "<img src='http://placehold.it/225x345&amp;text=No+image' alt>";
									}
								} ?>

								<div class="text">
									<span class="category"><?php the_category(', ');  ?></span>
									<h3>
										<a href="<?php the_permalink(); ?>" class="<?php if($blog_count == 3){
											echo'white-col';
										} else {
											echo'black-col';
										} ?> red-col-hover"><?php the_title(); ?></a>
									</h3>

									<div class="string">
										<?php if($blog_count == 2){
											echo ale_trim_excerpt(10);
										} elseif($blog_count == 3){

										} else {
											echo ale_trim_excerpt(20);
										} ?>
									</div>

									<div class="details">
										<span class="date"><?php the_time('j F Y'); ?></span>

										<?php if($blog_count != 3){ ?>
											<span class="comment">
												<i class="fa fa-comment"></i>
												<?php $comments_count = wp_count_comments($post->ID); echo esc_attr($comments_count->total_comments); ?>
											</span>
										<?php } ?>
									</div>

									<a href="<?php the_permalink(); ?>" class="link"><i class="fa fa-angle-right"></i></a>
								</div>
							</article>
						<?php endwhile; ?>
					</div>
				</section>
			<?php endif; wp_reset_postdata();?>

			<!-- Brands -->
			<section class="home-brands left">
				<h2><?php echo ale_get_meta_attr('home_brands_title'); ?></h2>

				<?php $slider = ale_sliders_get_slider('brands');
				if($slider):?>
					<div class="slider">
						<ul class="slides">
							<?php foreach ($slider['slides'] as $slide) : ?>
								<li>
									<article class="cf">
										<div class="image left">
											<img src="<?php if($slide['image']){
												echo esc_url($slide['image']);
											} else {
												echo 'http://placehold.it/150x125/&amp;text=No+Image';
											} ?>" alt="<?php echo esc_attr($slide['title']); ?>" />
										</div>

										<div class="text left">
											<h3><a href="<?php echo esc_url($slide['url']); ?>" class="black-col red-col-hover"><?php echo esc_attr($slide['title']) ?></a></h3>
											<p><?php echo esc_attr($slide['description']); ?></p>
										</div>
									</article>
								</li>
							<?php endforeach; ?>
						</ul>
					</div>

					<hr>
				<?php endif;?>

				<article class="home-person cf">
					<div class="image left">
						<img src="<?php if(ale_get_meta_attr('home_personal_image')){
							echo ale_get_meta_attr('home_personal_image');
						} else {
							echo 'http://placehold.it/252x391/&amp;text=No+Image';
						} ?>" alt="">
					</div>

					<div class="text left">
						<h3><?php echo ale_get_meta_attr('home_personal_name'); ?></h3>
						<span class="number"><?php echo ale_get_meta_attr('home_personal_phone'); ?></span>
						<p><?php echo ale_get_meta_attr('home_personal_text'); ?></p>
					</div>

					<div class="link cf">
						<div class="agent brown-bg left"><?php _e('Your personal agent', 'aletheme'); ?></div>
						<a href="<?php echo ale_get_meta_url('home_personal_link'); ?>" class="white-col red-col-hover left"><?php _e('Contact', 'aletheme'); ?><i class="fa fa-angle-right"></i></a>
					</div>
				</article>
			</section>
		</div>
	</div>
	<?php } ?>

	<?php if(ale_get_meta('display_email')!='off' && ale_get_meta('display_email')!='') { ?>
		<div class="wrapper white-dark-bg home-subscribe">
			<div id="subscribe" class="wrapper-inside">
				<?php if(shortcode_exists('mc4wp_form')) {
					echo do_shortcode( '[mc4wp_form]' );
				} ?>
			</div>
		</div>
	<?php } ?>

	<?php if(ale_get_meta("display_text")!='off') { ?>
		<section class="wrapper white-dark-bg home-text">
			<div class="wrapper-inside">
				<h2><?php echo ale_get_meta_attr('home_text_text'); ?></h2>
				<?php if (have_posts()) : while (have_posts()) : the_post();
					the_content();
				endwhile; endif; wp_reset_postdata();?>
			</div>
		</section>
	<?php } ?>

	<?php if(ale_get_meta('display_partners')!='off' && ale_get_meta('display_partners')!='') { ?>
		<div class="wrapper home-partners white-dark-bg">
			<?php if(ale_get_option('partner1')){ ?>
				<a href="<?php echo esc_url(ale_get_option('link_partner1')); ?>">
					<img src="<?php echo esc_url(ale_get_option('partner1')); ?>" alt>
				</a>
			<?php } ?>

			<?php if(ale_get_option('partner2')){ ?>
				<a href="<?php echo esc_url(ale_get_option('link_partner2')); ?>">
					<img src="<?php echo esc_url(ale_get_option('partner2')); ?>" alt>
				</a>
			<?php } ?>

			<?php if(ale_get_option('partner3')){ ?>
				<a href="<?php echo esc_url(ale_get_option('link_partner3')); ?>">
					<img src="<?php echo esc_url(ale_get_option('partner3')); ?>" alt>
				</a>
			<?php } ?>

			<?php if(ale_get_option('partner4')){ ?>
				<a href="<?php echo esc_url(ale_get_option('link_partner4')); ?>">
					<img src="<?php echo esc_url(ale_get_option('partner4')); ?>" alt>
				</a>
			<?php } ?>

			<?php if(ale_get_option('partner5')){ ?>
				<a href="<?php echo esc_url(ale_get_option('link_partner5')); ?>">
					<img src="<?php echo esc_url(ale_get_option('partner5')); ?>" alt>
				</a>
			<?php } ?>

			<?php if(ale_get_option('partner6')){ ?>
				<a href="<?php echo esc_url(ale_get_option('link_partner6')); ?>">
					<img src="<?php echo esc_url(ale_get_option('partner6')); ?>" alt>
				</a>
			<?php } ?>

			<?php if(ale_get_option('partner7')){ ?>
				<a href="<?php echo esc_url(ale_get_option('link_partner7')); ?>">
					<img src="<?php echo esc_url(ale_get_option('partner7')); ?>" alt>
				</a>
			<?php } ?>

			<?php if(ale_get_option('partner8')){ ?>
				<a href="<?php echo esc_url(ale_get_option('link_partner8')); ?>">
					<img src="<?php echo esc_url(ale_get_option('partner8')); ?>" alt>
				</a>
			<?php } ?>
		</div>
	<?php }?>

<?php get_footer(); ?>


