<?php
// Creating the widget
class Aletheme_recent_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		// Base ID of your widget
			'Aletheme_recent_Widget',

			// Widget name will appear in UI
			__('Aletheme recent posts Widget', 'aletheme'),

			// Widget description
			array( 'description' => __( 'A widget that display the recent posts.', 'aletheme' ), )
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		// before and after widget arguments are defined by themes
		echo $args['before_widget'];
		if ( ! empty( $title ) )
			echo $args['before_title'] . esc_attr($title) . $args['after_title'];
		?>

		<div class="recent_blog1">
			<h1><?php echo _e('RECENT POSTS','aletheme'); ?></h1>
			<div class="recent_posts">
				<?php
				wp_reset_postdata();
				$posts = new WP_Query(array( 'post_type' => 'post','posts_per_page'=>'3'));
				if( $posts->have_posts() ): while( $posts->have_posts() ) : $posts->the_post();
					?>
					<div class="recent_post">
						<a href="<?php the_permalink(); ?>"><?php echo  get_the_title(); ?></a>
						<div class="info_r"><?php the_time('j F Y'); ?>&nbsp;&nbsp;&nbsp;&nbsp;<i class="fa fa-comment"></i>&nbsp;&nbsp;<?php $num_comments=get_comments_number(); echo esc_attr($num_comments); ?></div>
					</div>
					<?php
				endwhile; endif;
				wp_reset_postdata();
				?>
			</div>
		</div>  <!-- end recent blog1 -->

		<?php
		echo $args['after_widget'];
	}

	// Widget Backend
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			//   $title = $instance[ 'title' ];
		}
		else {
			//  $title = __( 'New title', 'aletheme' );
		}
		// Widget admin form
		?>

	<?php
	}

	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		return $instance;
	}
} // Class wpb_widget ends here

// Register and load the widget
function aletheme_load_widget2() {
	register_widget( 'Aletheme_recent_Widget' );
}
add_action( 'widgets_init', 'aletheme_load_widget2' );
?>