<?php
// Creating the widget
class Aletheme_filter_Widget extends WP_Widget {

	function __construct() {
		parent::__construct(
		// Base ID of your widget
			'Aletheme_filter_Widget',

			// Widget name will appear in UI
			__('Aletheme filter Widget', 'aletheme'),

			// Widget description
			array( 'description' => __( 'A widget that display the filter for all cars.', 'aletheme' ), )
		);
	}

	// Creating widget front-end
	// This is where the action happens
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		// before and after widget arguments are defined by themes
		echo $args['before_widget'];
		if ( ! empty( $title ) )
			echo $args['before_title'] . $title . $args['after_title'];
		?>

		<div id="filter_all">
			<div class="find_car">
				<h2><?php echo _e('Find a car','aletheme'); ?></h2>
				<div id="s_all">
					<select class="dropdown" id="brand_select">
						<option selected disabled ><?php echo _e('Choose Brand','aletheme'); ?></option>
						<?php
						$brands=get_terms("brand-offers");
						foreach($brands as $brand) {
							?>
							<option value="<?php echo esc_attr($brand->term_id); ?>">
								<?php echo esc_attr($brand->name); ?>
							</option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" id="body_select">
						<option selected disabled ><?php echo _e('Body Style','aletheme'); ?></option>
						<?php
						$bodys=get_terms("body-offers");
						foreach($bodys as $body) {
							?>
							<option value="<?php echo esc_attr($body->term_id); ?>">
								<?php echo esc_attr($body->name); ?>
							</option>
						<?php
						}
						?>
					</select>

					<select class="dropdown" id="year_select">
						<option selected disabled ><?php echo _e('Year','aletheme'); ?></option>
						<?php
						$years=get_terms("year-offers");
						foreach($years as $year) {
							?>
							<option value="<?php echo esc_attr($year->term_id); ?>">
								<?php echo esc_attr($year->name); ?>
							</option>
						<?php
						}
						?>
					</select>
				</div>
			</div>
			<div class="vehicle_type">
				<h2><?php echo _e('Vehicle type','aletheme'); ?></h2>
				<div id="v_all">
					<?php
					$types=get_terms("vehicle_type");
					foreach($types as $type) { ?>
						<label>
							<input  type="checkbox" class="answer" value="<?php echo esc_attr($type->term_id); ?>" name="answer">
						    <span><?php echo esc_attr($type->name) . ' (' . $type->count;  ?>)</span>
						</label>
					<?php } ?>
				</div>
			</div>

			<div class="rangeSlider">
				<div class="rangeSldier__amount">
					<label><?php _e('Price range','aletheme'); ?></label>

					<div class="pricebox">
						<input type="text" name="price_down" value="<?php if(isset($_POST['price_down'])){ echo esc_attr($_POST['price_down']); } else { echo '0'; } ?>" class="sliderRange_first">
						<span> - </span>
						<input type="text" name="price_up" value="<?php if(isset($_POST['price_up'])){ echo esc_attr($_POST['price_up']); } else { echo '459000'; } ?>" class="sliderRange_last">
					</div>
				</div>
				<div class="rangeSldier_scale"></div>
			</div>

			<div class="fuel_type">
				<h2><?php echo _e('Fuel type','aletheme'); ?></h2>
				<div id="f_all">
					<?php
					$fuels=get_terms("fuel_type");
					foreach($fuels as $fuel) { ?>
						<label>
							<input type="checkbox" class="answer2" value="<?php echo esc_attr($fuel->term_id); ?>" name="answer2">
							<?php echo esc_attr($fuel->name) . ' (' . $fuel->count . ')'; ?>
						</label>
					<?php
					}
					?>
				</div>
			</div>

		</div>
		<?php
		echo $args['after_widget'];
	}

	// Widget Backend
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
		 //   $title = $instance[ 'title' ];
		}
		else {
		  //  $title = __( 'New title', 'aletheme' );
		}
		// Widget admin form
		?>

	<?php
	}

	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		return $instance;
	}
} // Class wpb_widget ends here

// Register and load the widget
function aletheme_load_widget() {
	register_widget( 'Aletheme_filter_Widget' );
}
add_action( 'widgets_init', 'aletheme_load_widget' );
?>