<?php

/**
 * Template Name: Template Blog 1
 */
get_header(); ?>
	<div class="wrapper white-dark-bg cf">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e("Blog","aletheme"); ?></span>

				<div class="breadcrumbs right">
					<i class="fa fa-home red-col"></i>
					<span typeof="v:Breadcrumb">
						<a rel="v:url" property="v:title" href="<?php echo home_url(); ?>"><?php _e('Home', 'aletheme'); ?></a>
					</span>&nbsp; › &nbsp;
					<span class="current"><?php _e('Blog', 'aletheme'); ?></span>
				</div>
			</div>
		</div>

		<div class="wrapper-inside typical-page page-template-blog-1">
			<div class="category-list">
				<?php $args = array(
					'show_option_all'    => '',
					'orderby'            => 'name',
					'order'              => 'ASC',
					'style'              => 'list',
					'show_count'         => 0,
					'hide_empty'         => 1,
					'use_desc_for_title' => 1,
					'child_of'           => 0,
					'feed'               => '',
					'feed_type'          => '',
					'feed_image'         => '',
					'exclude'            => '',
					'exclude_tree'       => '',
					'include'            => '',
					'hierarchical'       => 0,
					'title_li'           => '',
					'show_option_none'   => __( 'No categories','aletheme' ),
					'number'             => null,
					'echo'               => 1,
					'depth'              => 0,
					'current_category'   => 0,
					'pad_counts'         => 0,
					'taxonomy'           => 'category',
					'walker'             => null
				); ?>
				<ul class="cf">
					<?php wp_list_categories('title_li='); ?>
				</ul>
			</div>

			<div class="content_box left">
				<?php
				if ( get_query_var('paged') ){
					$paged = get_query_var('paged');
				} elseif ( get_query_var('page') ){
					$paged = get_query_var('page');
				} else{
					$paged = 'paged';
				}
				$count = intval(ale_get_option('blog_1'));
				$query_blog = new WP_Query(
					array(
						'posts_per_page' => $count,
						'post_type' => 'post',
						'ignore_sticky_posts' => 1,
						'post__not_in' => get_option('sticky_posts'),
						'paged' => $paged
					)
				);
				if ($query_blog->have_posts()) : while ($query_blog->have_posts()) : $query_blog->the_post(); ?>
					<article <?php post_class('item'); ?>>
						<div class="image">
							<a href="<?php the_permalink(); ?>">
								<?php if( get_the_post_thumbnail($post->ID,'post-blog1')) {
									echo get_the_post_thumbnail($post->ID,'post-blog1');
								} else {
									echo '<img class="non_image" src="http://placehold.it/683x343&amp;text=No+image" alt/>';
								} ?>
							</a>
						</div>

						<div class="text cf">
							<div class="author-logo left">
								<?php echo get_avatar(get_the_author_meta( 'user_email'),65); ?>
							</div>

							<div class="details left">
								<span class="author-name"><?php $author = get_the_author(); echo esc_attr($author); ?></span>
								<h2><a href="<?php the_permalink(); ?>" class="black-col red-col-hover"><?php echo get_the_title(); ?></a></h2>
								<span class="date"><?php the_time('j F Y'); ?></span>
							</div>

							<div class="string clear">
								<?php echo ale_trim_excerpt(50); ?>
							</div>
						</div>
					</article>
				<?php endwhile; endif; wp_reset_postdata(); ?>

				<?php echo ale_custom_page_links($query_blog); ?>
			</div>

			<?php get_sidebar(); ?>
		</div>
	</div>
<?php get_footer(); ?>