<!doctype html>
<!--[if lt IE 7]> <html class="no-js lt-ie9 lt-ie8 lt-ie7" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 7]>    <html class="no-js lt-ie9 lt-ie8" <?php language_attributes(); ?>> <![endif]-->
<!--[if IE 8]>    <html class="no-js lt-ie9" <?php language_attributes(); ?>> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js" <?php language_attributes(); ?>> <!--<![endif]-->
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<title><?php wp_title(); ?></title>
	<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
	<div class="gradient"></div>

	<!-- Header -->
	<header class="cf wrapper-header">
		<!-- Main Menu header -->
		<nav class="left-menu">
			<div class="menu-icon-left"><i class="fa fa-bars"></i></div>
			<?php if ( has_nav_menu( 'header_menu_left' ) ) {
				wp_nav_menu(array(
					'theme_location'=> 'header_menu_left',
					'menu'			=> 'Header  Menu Left',
					'menu_class'	=> 'menu menu-header ',
					'walker'		=> new Aletheme_Nav_Walker(),
					'container'		=> '',
				));
			} ?>
		</nav>

		<div class="sitelogo">
			<?php if(ale_get_option("site_logo")) { ?>
				<a href="<?php echo home_url(); ?>"> <img src="<?php echo esc_url(ale_get_option('site_logo')); ?>" alt="<?php echo bloginfo('name'); ?>"/></a>
			<?php } else { ?>
				<a href="<?php echo home_url(); ?>/">
					<span class="background black-bg"></span>
					<span class="text"><?php echo bloginfo('name'); ?></span>
				</a>
			<?php }?>
		</div>

		<nav class="right-menu">
			<div class="menu-icon-right"><i class="fa fa-bars"></i></div>
			<?php if ( has_nav_menu( 'header_menu_right' ) ) {
				wp_nav_menu(array(
					'theme_location'=> 'header_menu_right',
					'menu'			=> 'Header  Menu Right',
					'menu_class'	=> 'menu menu-header ',
					'walker'		=> new Aletheme_Nav_Walker(),
					'container'		=> '',
				));
			} ?>
		</nav>
	</header>

	<!--Color selector-->
	<?php if(ale_get_option('display_color_selector') != 'Disable'): ?>
		<div class="color-selector">
			<div class="show-colors red-bg grey-light-bg-hover"></div>
			<div class="colors-content">
				<h2><?php _e('Style selector', 'aletheme'); ?></h2>
				<hr>

				<h3><?php _e('Choose background pattern', 'aletheme'); ?>:</h3>
				<div class="background-choose clearfix">
					<div class="backgrounds">
						<div class="background background1" data-background="<?php echo get_template_directory_uri(); ?>/css/images/colorpicker/background/1.png"></div>
					</div>

					<div class="backgrounds">
						<div class="background background2" data-background="<?php echo get_template_directory_uri(); ?>/css/images/colorpicker/background/2.png"></div>
					</div>

					<div class="backgrounds">
						<div class="background background3" data-background="<?php echo get_template_directory_uri(); ?>/css/images/colorpicker/background/3.png"></div>
					</div>

					<div class="backgrounds">
						<div class="background background4" data-background="<?php echo get_template_directory_uri(); ?>/css/images/colorpicker/background/4.png"></div>
					</div>

					<div class="backgrounds">
						<div class="background background5" data-background="<?php echo get_template_directory_uri(); ?>/css/images/colorpicker/background/5.png"></div>
					</div>

					<div class="backgrounds">
						<div class="background background6" data-background="<?php echo get_template_directory_uri(); ?>/css/images/colorpicker/background/6.png"></div>
					</div>

					<div class="backgrounds">
						<div class="background background7" data-background="<?php echo get_template_directory_uri(); ?>/css/images/colorpicker/background/7.png"></div>
					</div>

					<div class="backgrounds">
						<div class="background background8" data-background="<?php echo get_template_directory_uri(); ?>/css/images/colorpicker/background/8.png"></div>
					</div>
				</div>
				<hr>

				<h3><?php _e('Choose color sheme', 'aletheme'); ?>:</h3>
			</div>

			<div class="colors-choose clearfix">
				<div class="colors">
					<div class="color color4 red-bg"></div>
					<div class="colorSelector" id="colorpickerHolder4"></div>
				</div>

			</div>
		</div>
	<?php endif; ?>

