<?php get_header(); ?>

	<div class="wrapper cf white-dark-bg">
		<div class="page-header">
			<div class="wrapper-inside cf">
				<span class="page-name left"><?php _e("Listing","aletheme"); ?></span>

				<?php echo get_breadcrumbs(); ?>
			</div>
		</div>

		<?php ale_part('filter'); ?>

			<div class="wrapper-inside">
				<div class="archive-page-listing wrapper-inside isotope cf">
					<?php wp_reset_postdata();
					if(isset($_POST['price_down']))
					{
						$price_min=$_POST['price_down'];
					}
					if(isset($_POST['price_up'])) {
						$price_max=$_POST['price_up'];
					}
					$count = ale_get_option('listing_num');
					if ( get_query_var('paged') ) $paged = get_query_var('paged');
					if ( get_query_var('page') ) $paged = get_query_var('page');
					$args = array(
						'posts_per_page' => $count,
						'post_type' => 'listing',
						'paged' => $paged,
						'tax_query' => array(
							'relation' => 'AND',
						),
						'meta_query' => array(
							'relation' => 'AND',

						)
					);

					if(isset($_POST['brand'])) {
						$brand=$_POST['brand'];
						array_push($args['tax_query'], array(
						  'taxonomy' => 'brand-listing',
							'terms' => $brand

						));
					}
					if(isset($_POST['status'])) {
						$status=$_POST['status'];
						array_push($args['tax_query'], array(
							'taxonomy' => 'status-listing',
							'terms' => $status
						));
					}
					if(isset($price_min) && isset($price_max)){
						array_push($args['meta_query'],array(
							'key' => 'ale_pret_car',
							'value' => array( $price_min, $price_max ),
							'type' => 'numeric',
							'compare' => 'BETWEEN'
						));
					}
					$listing_count = 0;
					$query_listing = new WP_Query( $args );
					if ($query_listing->have_posts()) : while ($query_listing->have_posts()) : $query_listing->the_post(); $listing_count++;
						if($listing_count == 2){
							$listing_style = ' big';
						} else {
							$listing_style = '';
						} ?>
						<article <?php post_class('item left' . $listing_style); ?>>
							<?php if($listing_count == 2){
								if(get_the_post_thumbnail($post->ID,'listing-max')) {
									echo get_the_post_thumbnail($post->ID,'listing-max');
								} else {
									echo '<img class="non_image" src="http://placehold.it/490x255" alt>';
								}
							} else {
								if(get_the_post_thumbnail($post->ID,'listing-min')) {
									echo get_the_post_thumbnail($post->ID,'listing-min');
								} else {
									echo '<img class="non_image" src="http://placehold.it/245x255" alt>';
								}
							}?>

							<div class="text cf">
								<h2<?php if($listing_count == 2){echo' class="left"';} ?>>
									<?php $current_category = wp_get_post_terms($post->ID, 'brand-listing', array("fields" => "all"));
									if($current_category){
										foreach($current_category as $curcat){
											echo '<span>' . $curcat->name . '</span> ';
										}
									}
									the_title(); ?>
								</h2>

								<div class="details<?php if($listing_count == 2){echo' left';} ?>">
									<?php $current_category = wp_get_post_terms($post->ID, 'fuel-listing', array("fields" => "all"));
									if($current_category){
										echo '<p class="cf"><span class="caption left">' . __('Fuel','aletheme') . '</span>';
										foreach($current_category as $curcat){
											echo '<span class="right">' . $curcat->name . '</span>';
										}
										echo '</p>';
									}?>

									<?php $current_category = wp_get_post_terms($post->ID, 'year-listing', array("fields" => "all"));
									if($current_category){
										echo '<p class="cf"><span class="caption left">' . __('Year','aletheme') . '</span>';
										foreach($current_category as $curcat){
											echo '<span class="right">' . $curcat->name . '</span>';
										}
										echo '</p>';
									}?>

									<?php $current_category = wp_get_post_terms($post->ID, 'transmission-listing', array("fields" => "all"));
									if($current_category){
										echo '<p class="cf"><span class="caption left">' . __('Transmission','aletheme') . '</span>';
										foreach($current_category as $curcat){
											echo '<span class="right">' . $curcat->name . '</span>';
										}
										echo '</p>';
									}?>

									<?php if(ale_get_meta("location_car")){ ?>
										<p class="cf"><span class="caption left"><?php echo _e('Location','aletheme'); ?></span><span class="right"><?php echo esc_attr(ale_get_meta("location_car")); ?></span></p>
									<?php } ?>
								</div>

								<div class="information<?php if($listing_count == 2){echo' left';} ?>">
									<?php if(ale_get_meta('brakes_car')){ ?>
										<i class="fa fa-dot-circle-o grey-col"></i>
									<?php } ?>

									<?php if(ale_get_meta('transmission_icon_car')){ ?>
										<i class="fa fa-gavel grey-col"></i>
									<?php } ?>

									<?php if(ale_get_meta('oil_car')){ ?>
										<i class="fa fa-flask grey-col"></i>
									<?php } ?>

									<?php if(ale_get_meta('repair_car')){ ?>
										<i class="fa fa-wrench grey-col"></i>
									<?php } ?>
								</div>
							</div>

							<a href="<?php echo  the_permalink(); ?>"></a>
						</article>
					<?php endwhile; endif; wp_reset_postdata(); ?>
				</div>

				<?php ale_custom_page_links($query_listing); ?>
			</div>
		</div>
<?php get_footer(); ?>
