<?php add_action('admin_init', 'add_meta_boxes1', 1);
function add_meta_boxes1() {
    add_meta_box( 'ale_interior_m', 'Interior Details M', 'ale_interior_m_box_display', 'listing', 'normal', 'high');
}

function ale_interior_m_box_display() {
    global $post;

    $ale_properties_details_m = get_post_meta($post->ID, 'ale_interior_m', true);



    wp_nonce_field( 'ale_interior_m_box_nonce', 'ale_interior_m_box_nonce' );
    ?>
    <script type="text/javascript">
        jQuery(document).ready(function($) {
            $('.metabox_submit1').click(function(e) {
                e.preventDefault();
                $('#publish').click();
            });
            $('#add-row1').on('click', function() {
                var row = $('.empty-row1.screen-reader-text').clone(true);
                row.removeClass('empty-row1 screen-reader-text');
                row.insertBefore('#repeatable-fieldset-one1 tbody>tr:last');
                return false;
            });
            $('.remove-row1').on('click', function() {
                $(this).parents('tr').remove();
                return false;
            });

            $('#repeatable-fieldset-one1 tbody').sortable({
                opacity: 0.6,
                revert: true,
                cursor: 'move',
                handle: '.sort'
            });
        });
    </script>

    <table id="repeatable-fieldset-one1" width="100%">
        <thead>
        <tr>
            <th width="2%"></th>
            <th width="30%">Title</th>
            <th width="60%">Value</th>
            <th width="2%"></th>
        </tr>
        </thead>
        <tbody>
        <?php

        if ( $ale_properties_details_m) :

            foreach ( $ale_properties_details_m as $field ) {
                ?>
                <tr>
                    <td><a class="button remove-row1" href="#"><span class="dashicons dashicons-trash"></span></a></td>
                    <td><input type="text" class="widefat" name="title1[]" value="<?php if($field['title'] != '') echo esc_attr( $field['title'] ); ?>" /></td>

                    <td><input type="text" class="widefat" name="value1[]" value="<?php if ($field['value'] != '') echo esc_attr( $field['value'] );  ?>" /></td>
                    <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

                </tr>
            <?php
            }
        else :
            // show a blank one
            ?>
            <tr>
                <td><a class="button remove-row1" href="#"><span class="dashicons dashicons-trash"></span></a></td>
                <td><input type="text" class="widefat" name="title1[]" /></td>


                <td><input type="text" class="widefat" name="value1[]" value="" /></td>
                <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

            </tr>

        <?php endif; ?>

        <!-- empty hidden one for jQuery -->
        <tr class="empty-row1 screen-reader-text">
            <td><a class="button remove-row1" href="#"><span class="dashicons dashicons-trash"></span></a></td>
            <td><input type="text" class="widefat" name="title1[]" /></td>


            <td><input type="text" class="widefat" name="value1[]" value="" /></td>
            <td><a class="sort"><span class="dashicons dashicons-sort" title="<?php _e('Click and Drag','aletheme');?>"></span></a></td>

        </tr>
        </tbody>
    </table>



    <p><a id="add-row1" class="button" href="#"><span class="dashicons dashicons-plus" style="line-height: 28px; font-size:14px;"></span> Add another</a>
        <input type="submit" class="metabox_submit1" value="Save" />
    </p>

<?php
}

add_action('save_post', 'ale_interior_m_box_save');
function ale_interior_m_box_save($post_id) {
    if ( ! isset( $_POST['ale_interior_m_box_nonce'] ) ||
        ! wp_verify_nonce( $_POST['ale_interior_m_box_nonce'], 'ale_interior_m_box_nonce' ) )

        return;

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE)
        return;

    if (!current_user_can('edit_post', $post_id))
        return;

    $old = get_post_meta($post_id, 'ale_interior_m', true);
    $new = array();


    $titles = $_POST['title1'];
    $values = $_POST['value1'];

    $count = count( $titles );

    for ( $i = 0; $i < $count; $i++ ) {
        if ( $titles[$i] != '' ) :
            $new[$i]['title'] = stripslashes( strip_tags( $titles[$i] ) );
            $new[$i]['value'] = stripslashes( $values[$i] );
        endif;
    }

    if ( !empty( $new ) && $new != $old )
        update_post_meta( $post_id, 'ale_interior_m', $new );
    elseif ( empty($new) && $old )
        delete_post_meta( $post_id, 'ale_interior_m', $old );
}

