<?php
/**
 * Get current theme options
 * 
 * @return array
 */
function aletheme_get_options() {
	$comments_style = array(
		'wp'  => 'Alethemes Comments',
		'fb'  => 'Facebook Comments',
		'dq'  => 'DISQUS',
		'lf'  => 'Livefyre',
		'off' => 'Disable All Comments',
	);

    $analytics = array(
        'classic'  => 'Classic Analytics',
        'universal'  => 'Universal Analytics',
    );

    $headerfont = array_merge(ale_get_safe_webfonts(), ale_get_google_webfonts());

    $background_defaults = array(
        'color' => '',
        'image' => get_template_directory_uri().'/css/images/background.jpg',
        'repeat' => 'repeat',
        'position' => 'top center',
        'attachment'=>'scroll'
    );

	
	$imagepath =  ALETHEME_URL . '/assets/images/';
	
	$options = array();
		
	$options[] = array("name" => "Theme",
						"type" => "heading");

    $options[] = array( "name" => "Site Logo",
                        "desc" => "Upload or put the site logo link (Default logo size: 318-110px)",
                        "id" => "ale_sitelogo",
                        "std" => "",
                        "type" => "upload");

    $options[] = array( "name" => "Mobile Logo",
                        "desc" => "Upload or put the site logo link (Default logo size: 200-69px)",
                        "id" => "ale_mobsitelogo",
                        "std" => "",
                        "type" => "upload");

    $options[] = array( "name" => "Footer Logo",
                        "desc" => "Upload or put the site logo link (Default logo size: 78-37px)",
                        "id" => "ale_footerlogo",
                        "std" => "",
                        "type" => "upload");

    $options[] = array( 'name' => "Manage Background",
                        'desc' => "Select the background color, or upload a custom background image. Default background is the #f5f5f5 color",
                        'id' => 'ale_background',
                        'std' => $background_defaults,
                        'type' => 'background');

    $options[] = array( "name" => "Background Size Cover",
                        "desc" => "Check if you want to select cover background size",
                        "id" => "ale_backcover",
                        "std" => "1",
                        "type" => "checkbox");

    $options[] = array( "name" => "Uplaod a favicon icon",
                        "desc" => "Upload or put the link of your favicon icon",
                        "id" => "ale_favicon",
                        "std" => "",
                        "type" => "upload");

	$options[] = array( "name" => "Comments Style",
						"desc" => "Choose your comments style. If you want to use DISQUS comments please install and activate this plugin from <a href=\"" . admin_url('plugin-install.php?tab=search&type=term&s=Disqus+Comment+System&plugin-search-input=Search+Plugins') . "\">Wordpress Repository</a>.  If you want to use Livefyre Realtime Comments comments please install and activate this plugin from <a href=\"" . admin_url('plugin-install.php?tab=search&type=term&s=Livefyre+Realtime+Comments&plugin-search-input=Search+Plugins') . "\">Wordpress Repository</a>.",
						"id" => "ale_comments_style",
						"std" => "wp",
						"type" => "select",
						"options" => $comments_style);


	$options[] = array( "name" => "Social Sharing",
						"desc" => "Enable social sharing for posts.",
						"id" => "ale_social_sharing",
						"std" => "1",
						"type" => "checkbox");

    $options[] = array( "name" => "Copyrights",
                        "desc" => "Your copyright message.",
                        "id" => "ale_copyrights",
                        "std" => "",
                        "type" => "editor");

    $options[] = array( "name" => "Home Page Slider slug",
                        "desc" => "Insert the slider slug. Get the slug on Sliders Section",
                        "id" => "ale_homeslugfull",
                        "std" => "",
                        "type" => "text");


    $options[] = array( "name" => "Typography",
                        "type" => "heading");

    $options[] = array( "name" => "Select the Font from Google Library",
                        "desc" => "The default Font is - McLaren",
                        "id" => "ale_headerfont",
                        "std" => "McLaren",
                        "type" => "select",
                        "options" => $headerfont);

    $options[] = array( "name" => "Select the Font (Extended) from Google Library",
                        "desc" => "The default Font",
                        "id" => "ale_headerfontex",
                        "std" => "",
                        "type" => "text",
                        );


    $options[] = array( 'name' => "H1 Style",
                        'desc' => "Change the h1 style",
                        'id' => 'ale_h1sty',
                        'std' => array('size' => '22px','face' => 'McLaren','style' => 'normal','color' => '#ffffff'),
                        'type' => 'typography');

    $options[] = array( 'name' => "H2 Style",
                        'desc' => "Change the h2 style",
                        'id' => 'ale_h2sty',
                        'std' => array('size' => '20px','face' => 'McLaren','style' => 'normal','color' => '#ffffff'),
                        'type' => 'typography');

    $options[] = array( 'name' => "H3 Style",
                        'desc' => "Change the h3 style",
                        'id' => 'ale_h3sty',
                        'std' => array('size' => '18px','face' => 'McLaren','style' => 'normal','color' => '#ffffff'),
                        'type' => 'typography');

    $options[] = array( 'name' => "H4 Style",
                        'desc' => "Change the h4 style",
                        'id' => 'ale_h4sty',
                        'std' => array('size' => '16px','face' => 'McLaren','style' => 'normal','color' => '#ffffff'),
                        'type' => 'typography');

    $options[] = array( 'name' => "H5 Style",
                        'desc' => "Change the h5 style",
                        'id' => 'ale_h5sty',
                        'std' => array('size' => '14px','face' => 'McLaren','style' => 'normal','color' => '#ffffff'),
                        'type' => 'typography');

    $options[] = array( 'name' => "H6 Style",
                        'desc' => "Change the h6 style",
                        'id' => 'ale_h6sty',
                        'std' => array('size' => '12px','face' => 'McLaren','style' => 'normal','color' => '#ffffff'),
                        'type' => 'typography');

    $options[] = array( 'name' => "Body Style",
                        'desc' => "Change the body font style",
                        'id' => 'ale_bodystyle',
                        'std' => array('size' => '11px','face' => 'McLaren','style' => 'normal','color' => '#ffffff'),
                        'type' => 'typography');

	$options[] = array( "name" => "Social",
						"type" => "heading");

    $options[] = array( "name" => "Twitter",
                        "desc" => "Your twitter profile URL.",
                        "id" => "ale_twi",
                        "std" => "",
                        "type" => "text");
	$options[] = array( "name" => "Facebook",
						"desc" => "Your facebook profile URL.",
						"id" => "ale_fb",
						"std" => "",
						"type" => "text");
    $options[] = array( "name" => "Pinterest",
                        "desc" => "Your pinteres profile URL.",
                        "id" => "ale_pint",
                        "std" => "",
                        "type" => "text");
    $options[] = array( "name" => "Instagram",
                        "desc" => "Your instagram profile URL.",
                        "id" => "ale_insta",
                        "std" => "",
                        "type" => "text");
    $options[] = array( "name" => "Youtube",
                        "desc" => "Your yuotube profile URL.",
                        "id" => "ale_youtube",
                        "std" => "",
                        "type" => "text");
    $options[] = array( "name" => "Email",
                        "desc" => "Your email",
                        "id" => "ale_emailcont",
                        "std" => "",
                        "type" => "text");
    $options[] = array( "name" => "Show RSS",
                        "desc" => "Check if you want to show the RSS icon on your site",
                        "id" => "ale_rssicon",
                        "std" => "1",
                        "type" => "checkbox");


	$options[] = array( "name" => "Facebook Application ID",
						"desc" => "If you have Application ID you can connect the blog to your Facebook Profile and monitor statistics there.",
						"id" => "ale_fb_id",
						"std" => "",
						"type" => "text");

	$options[] = array( "name" => "Enable Open Graph",
						"desc" => "The <a href=\"http://www.ogp.me/\">Open Graph</a> protocol enables any web page to become a rich object in a social graph.",
						"id" => "ale_og_enabled",
						"std" => "",
						"type" => "checkbox");



	$options[] = array( "name" => "Advanced Settings",
						"type" => "heading");

    $options[] = array( "name" => "Google Analytics Type",
                        "desc" => "Select the google analytics code type. Universal or Classic (The difference between versions you will find in google)",
                        "id" => "ale_analyticstype",
                        "std" => "classic",
                        "type" => "select",
                        "options" => $analytics);
	
	$options[] = array( "name" => "Google Analytics",
						"desc" => "Please insert your Google Analytics code here. Example: <strong>UA-22231623-1</strong>",
						"id" => "ale_ga",
						"std" => "",
						"type" => "text");
	
	$options[] = array( "name" => "Footer Code",
						"desc" => "If you have anything else to add in the footer - please add it here.",
						"id" => "ale_footer_info",
						"std" => "",
						"type" => "textarea");

    $options[] = array( "name" => "Custom CSS Styles",
                        "desc" => "You can add here your styles. ex. .boxclass { padding:10px; }",
                        "id" => "ale_customcsscode",
                        "std" => "",
                        "type" => "textarea");


    $options[] = array( "name" => "Footer",
                        "type" => "heading");

    $options[] = array(
                        'name' => 'Phone number',
                        'desc' => 'Your phone number',
                        'id'   => 'ale_footerphone',
                        'std' => '8 800 435-17-20',
                        'type'    => 'text');

    $options[] = array(
                        'name' => 'Email',
                        'desc' => 'Your Email',
                        'id'   => 'ale_footeremail',
                        'std' => 'nfo@bebe.co.uk',
                        'type'    => 'text');

    $options[] = array(
                        'name' => 'Address',
                        'desc' => 'Your address',
                        'id'   => 'ale_footeraddress',
                        'std' => 'Germany Berlin, Main street 43',
                        'type'    => 'text');

    $options[] = array( "name" => "Home, About Section",
                        "type" => "heading");

    $options[] = array(
                        'name' => 'Left block',
                        'desc' => '',
                        'id'   => 'ale_textbloc',
                        'type'    => 'title');

    $options[] = array(
                        'name' => 'Title',
                        'desc' => 'Insert title',
                        'id'   => 'ale_textblocktitle',
                        'std' => 'About Us',
                        'type'    => 'text');

    $options[] = array(
                        'name' => 'Image',
                        'desc' => 'Upload image. Size 280x168',
                        'id'   => 'ale_textblockimage',
                        'std' => '',
                        'type'    => 'upload');

    $options[] = array(
                        'name' => 'Content',
                        'desc' => 'Insert any text',
                        'id'   => 'ale_textblockcontent',
                        'std' => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into',
                        'type'    => 'textarea');

    $options[] = array(
                        'name' => 'Link',
                        'desc' => 'Insert link',
                        'id'   => 'ale_textblocklink',
                        'std' => '',
                        'type'    => 'text');

    $options[] = array(
                        'name' => 'Right block',
                        'desc' => '',
                        'id'   => 'ale_tetxbloc2',
                        'type'    => 'title');

    $options[] = array(
                        'name' => '№1 Title',
                        'desc' => 'Insert title',
                        'id'   => 'ale_textblocktitle1',
                        'std' => 'Lorem ipsum',
                        'type'    => 'text');

    $options[] = array(
                        'name' => '№1 Image',
                        'desc' => 'Upload image. Size 51x44',
                        'id'   => 'ale_textblockimage1',
                        'std' =>  get_template_directory_uri().'/css/images/home/about-1.png',
                        'type'    => 'upload');

    $options[] = array(
                        'name' => '№1 Content',
                        'desc' => 'Insert any text',
                        'id'   => 'ale_textblockcontent1',
                        'std' => 'Lorem Ipsum is simply dummy text printing',
                        'type'    => 'textarea');

    $options[] = array(
                        'name' => '№1 Link',
                        'desc' => 'Insert link',
                        'id'   => 'ale_textlocklink1',
                        'std' => '',
                        'type'    => 'text');

    $options[] = array(
                        'name' => '№2 Title',
                        'desc' => 'Insert title',
                        'id'   => 'ale_textblocktitle2',
                        'std' => 'Simple text here',
                        'type'    => 'text');

    $options[] = array(
                        'name' => '№2 Image',
                        'desc' => 'Upload image. Size 51x44',
                        'id'   => 'ale_textblockimage2',
                        'std' => get_template_directory_uri().'/css/images/home/about-2.png',
                        'type'    => 'upload');

    $options[] = array(
                        'name' => '№2 Content',
                        'desc' => 'Insert any text',
                        'id'   => 'ale_textblockcontent2',
                        'std' => 'Lorem Ipsum is simply of the',
                        'type'    => 'textarea');

    $options[] = array(
                        'name' => '№2 Link',
                        'desc' => 'Insert link',
                        'id'   => 'ale_textblocklink2',
                        'std' => '',
                        'type'    => 'text');

    $options[] = array(
                        'name' => '№3 Title',
                        'desc' => 'Insert title',
                        'id'   => 'ale_textblocktitle3',
                        'std' => 'Dummy text',
                        'type'    => 'text');

    $options[] = array(
                        'name' => '№3 Image',
                        'desc' => 'Upload image. Size 51x44',
                        'id'   => 'ale_textblockimage3',
                        'std' => get_template_directory_uri().'/css/images/home/about-3.png',
                        'type'    => 'upload');

    $options[] = array(
                        'name' => '№3 Content',
                        'desc' => 'Insert any text',
                        'id'   => 'ale_textblockcontent3',
                        'std' => 'Lorem Ipsum is simply dummy text of the',
                        'type'    => 'textarea');

    $options[] = array(
                        'name' => '№3 Link',
                        'desc' => 'Insert link',
                        'id'   => 'ale_textblocklink3',
                        'std' => '',
                        'type'    => 'text');


	return $options;
}

/**
 * Add custom scripts to Options Page
 */
function aletheme_options_custom_scripts() {
 ?>

<script type="text/javascript">
jQuery(document).ready(function() {
    jQuery('#ale_commentongallery').click(function() {
        jQuery('#section-ale_gallerycomments_style').fadeToggle(400);
    });
    if (jQuery('#ale_commentongallery:checked').val() !== undefined) {
        jQuery('#section-ale_gallerycomments_style').show();
    }
});
</script>

<?php
}

/**
 * Add Metaboxes
 * @param array $meta_boxes
 * @return array 
 */
function aletheme_metaboxes($meta_boxes) {
	
	$meta_boxes = array();

    $prefix = "ale_";


    $meta_boxes[] = array(
        'id'         => 'contact_page_metabox',
        'title'      => 'Contact Page Options',
        'pages'      => array( 'page', ), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        'show_on'    => array( 'key' => 'page-template', 'value' => array('template-contact.php'), ), // Specific post templates to display this metabox
        'fields' => array(
            array(
                'name' => 'Map, Address',
                'desc' => 'Insert the Address',
                'id'   => $prefix . 'contactaddressmap',
                'std' => 'Germany Berlin, Main street 43',
                'type' => 'text',
            ),
            array(
                'name' => 'Phone',
                'desc' => 'Insert phone number',
                'id'   => $prefix . 'contactphone',
                'std' => '8 800 435-17-25 / 8 800 435-17-26',
                'type' => 'text',
            ),
            array(
                'name' => 'Email',
                'desc' => 'Insert email address',
                'id'   => $prefix . 'contactemail',
                'std' => 'nfo@bebe.co.uk / sales@bebe.co.uk',
                'type' => 'text',
            ),
        )
    );

    $meta_boxes[] = array(
        'id'         => 'aboutslider_page_metabox',
        'title'      => 'About Page Options',
        'pages'      => array( 'page', ), // Post type
        'context'    => 'normal',
        'priority'   => 'high',
        'show_names' => true, // Show field names on the left
        'show_on'    => array( 'key' => 'page-template', 'value' => array('template-about.php'), ), // Specific post templates to display this metabox
        'fields' => array(
            array(
                'name' => 'Our Teachers',
                'desc' => '',
                'id'   => $prefix . 'ourteachers',
                'type'    => 'title',
            ),
            array(
                'name' => '№1 Name',
                'desc' => 'Insert teacher name',
                'id'   => $prefix . 'ourteachersname1',
                'std' => 'Ellene Marlen',
                'type'    => 'text',
            ),
            array(
                'name' => '№1 Photo',
                'desc' => 'Upload teacher photo. Size: 281x163',
                'id'   => $prefix . 'ourteachersphoto1',
                'type'    => 'file',
            ),
            array(
                'name' => '№1 Text',
                'desc' => 'Add any information',
                'id'   => $prefix . 'ourteacherstext1',
                'std' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure',
                'type'    => 'textarea',
            ),
            array(
                'name' => '№1 Facebook',
                'desc' => 'Insert facebook profile link',
                'id'   => $prefix . 'ourteachersfacebook1',
                'type'    => 'text',
            ),
            array(
                'name' => '№1 Pinterest',
                'desc' => 'Insert pinterest profile link',
                'id'   => $prefix . 'ourteacherspinterest1',
                'type'    => 'text',
            ),
            array(
                'name' => '№1 Twitter',
                'desc' => 'Insert twitter profile link',
                'id'   => $prefix . 'ourteacherstwitter1',
                'type'    => 'text',
            ),
            array(
                'name' => '№2 Name',
                'desc' => 'Insert teacher name',
                'id'   => $prefix . 'ourteachersname2',
                'std' => 'Nicole Blume',
                'type'    => 'text',
            ),
            array(
                'name' => '№2 Photo',
                'desc' => 'Upload teacher photo. Size: 281x163',
                'id'   => $prefix . 'ourteachersphoto2',
                'type'    => 'file',
            ),
            array(
                'name' => '№2 Text',
                'desc' => 'Add any information',
                'id'   => $prefix . 'ourteacherstext2',
                'std' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure',
                'type'    => 'textarea',
            ),
            array(
                'name' => '№2 Facebook',
                'desc' => 'Insert facebook profile link',
                'id'   => $prefix . 'ourteachersfacebook2',
                'type'    => 'text',
            ),
            array(
                'name' => '№2 Pinterest',
                'desc' => 'Insert pinterest profile link',
                'id'   => $prefix . 'ourteacherspinterest2',
                'type'    => 'text',
            ),
            array(
                'name' => '№2 Twitter',
                'desc' => 'Insert twitter profile link',
                'id'   => $prefix . 'ourteacherstwitter2',
                'type'    => 'text',
            ),
            array(
                'name' => '№3 Name',
                'desc' => 'Insert teacher name',
                'id'   => $prefix . 'ourteachersname3',
                'std' => 'Alex Socha',
                'type'    => 'text',
            ),
            array(
                'name' => '№3 Photo',
                'desc' => 'Upload teacher photo. Size: 281x163',
                'id'   => $prefix . 'ourteachersphoto3',
                'type'    => 'file',
            ),
            array(
                'name' => '№3 Text',
                'desc' => 'Add any information',
                'id'   => $prefix . 'ourteacherstext3',
                'std' => 'Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis no ullamco laboris nisi ut aliquip ex ea commodo consequat.',
                'type'    => 'textarea',
            ),
            array(
                'name' => '№3 Facebook',
                'desc' => 'Insert facebook profile link',
                'id'   => $prefix . 'ourteachersfacebook3',
                'type'    => 'text',
            ),
            array(
                'name' => '№3 Pinterest',
                'desc' => 'Insert pinterest profile link',
                'id'   => $prefix . 'ourteacherspinterest3',
                'type'    => 'text',
            ),
            array(
                'name' => '№3 Twitter',
                'desc' => 'Insert twitter profile link',
                'id'   => $prefix . 'ourteacherstwitter3',
                'type'    => 'text',
            ),
        )
    );

	return $meta_boxes;
}

/**
 * Get image sizes for images
 * 
 * @return array
 */
function aletheme_get_images_sizes() {
	return array(

        'gallery' => array(
            array(
                'name'      => 'gallery-thumba',
                'width'     => 430,
                'height'    => 267,
                'crop'      => true,
            ),
            array(
                'name'      => 'gallery-mini',
                'width'     => 100,
                'height'    => 67,
                'crop'      => true,
            ),
            array(
                'name'      => 'gallery-big',
                'width'     => 680,
                'height'    => 9999,
                'crop'      => true,
            ),
            array(
                'name'      => 'gallery-gallery-1',
                'width'     => 456,
                'height'    => 164,
                'crop'      => true,
            ),
            array(
                'name'      => 'gallery-gallery-2',
                'width'     => 222,
                'height'    => 164,
                'crop'      => true,
            ),
            array(
                'name'      => 'gallery-gallery-3',
                'width'     => 222,
                'height'    => 341,
                'crop'      => true,
            ),
            array(
                'name'      => 'main-slider-thumba',
                'width'     => 1000,
                'height'    => 356,
                'crop'      => true,
            ),
            array(
                'name'      => 'about-slider-thumba',
                'width'     => 470,
                'height'    => 326,
                'crop'      => true,
            ),
            array(
                'name'      => 'gallery-slider-thumba',
                'width'     => 920,
                'height'    => 505,
                'crop'      => true,
            ),
        ),
        'post' => array(
            array(
                'name'      => 'post-thumba',
                'width'     => 475,
                'height'    => 295,
                'crop'      => true,
            ),
            array(
                'name'      => 'post-small-thumba',
                'width'     => 235,
                'height'    => 183,
                'crop'      => true,
            ),
            array(
                'name'      => 'post-medium-thumba',
                'width'     => 368,
                'height'    => 281,
                'crop'      => true,
            ),
        ),
        'rooms' => array(
            array(
                'name'      => 'rooms-thumba',
                'width'     => 237,
                'height'    => 193,
                'crop'      => true,
            ),
            array(
                'name'      => 'rooms-slider-thumba',
                'width'     => 490,
                'height'    => 382,
                'crop'      => true,
            ),
        ),

    );
}

/**
 * Add post types that are used in the theme 
 * 
 * @return array
 */
function aletheme_get_post_types() {
	return array(
        'gallery' => array(
            'config' => array(
                'public' => true,
                'menu_position' => 20,
                'has_archive'   => true,
                'supports'=> array(
                    'title',
                    'editor',
                    'thumbnail',
                ),
                'show_in_nav_menus'=> true,
            ),
            'singular' => 'Gallery',
            'multiple' => 'Galleries',
            'columns'    => array(
                'first_image',
            )
        ),
        'rooms' => array(
            'config' => array(
                'public' => true,
                'menu_position' => 21,
                'has_archive'   => true,
                'supports'=> array(
                    'title',
                    'editor',
                    'thumbnail',
                ),
                'show_in_nav_menus'=> true,
            ),
            'singular' => 'Rooms',
            'multiple' => 'Rooms',
            'columns'    => array(
                'first_image',
            )
        ),

    );
}

/**
 * Add taxonomies that are used in theme
 * 
 * @return array
 */
function aletheme_get_taxonomies() {
	return array(

        'gallery-category'    => array(
            'for'        => array('gallery'),
            'config'    => array(
                'sort'        => true,
                'args'        => array('orderby' => 'term_order'),
                'hierarchical' => true,
            ),
            'singular'    => 'Gallery Category',
            'multiple'    => 'Gallery Categories',
        ),
    );
}

/**
 * Add post formats that are used in theme
 * 
 * @return array
 */
function aletheme_get_post_formats() {
	return array();
}

/**
 * Get sidebars list
 * 
 * @return array
 */
function aletheme_get_sidebars() {
	$sidebars = array();
	return $sidebars;
}

/**
 * Predefine custom sliders
 * @return array
 */
function aletheme_get_sliders() {
	return array(
		'sneak-peek' => array(
			'title'		=> 'Sneak Peek',
		),
	);
}

/**
 * Post types where metaboxes should show
 * 
 * @return array
 */
function aletheme_get_post_types_with_gallery() {
	return array('gallery','post', 'page','rooms');
}

/**
 * Add custom fields for media attachments
 * @return array
 */
function aletheme_media_custom_fields() {
	return array();
}