<?php 
/**
 * Template Name: Template Contact
 */
// send contact
if (isset($_POST['contact'])) {
    $error = ale_send_contact($_POST['contact']);
}
get_header();
?>
    <!-- Content Section -->
    <section class="center-align">

        <!-- Caption -->
        <div class="title-page">
            <h2><?php _e('Contact Us', 'aletheme'); ?></h2>
            <div class="page"><span class="home"></span> <?php the_breadcrumb(); ?></div>
        </div>

        <!-- -->
        <div class="dotted-line"></div>

        <!-- Contacts -->
        <article class="contacts">

            <div class="info-line cf">
                <div class="map">
                    <?php $adre = ale_get_meta('contactaddressmap'); echo do_shortcode('[ale_map address="'.$adre.'"]'); ?>
                </div>

                <?php  if (have_posts()) : while (have_posts()) : the_post(); ?>
                    <?php the_content();?>
                <?php endwhile;  endif;?>

                <div class="contactos">
                    <div class="adress">
                        <div class="icon"></div>
                        <h3><?php _e('Address','aletheme'); ?></h3>
                        <p><?php echo ale_get_meta('contactaddressmap');?></p>
                    </div>
                    <div class="phone">
                        <div class="icon"></div>
                        <h3><?php _e('Phone','aletheme'); ?></h3>
                        <p><?php echo ale_get_meta('contactphone');?></p>
                    </div>
                    <div class="email">
                        <div class="icon"></div>
                        <h3><?php _e('Email','aletheme'); ?></h3>
                        <p><?php echo ale_get_meta('contactemail');?></p>
                    </div>
                </div>


            </div>

            <div class="respond">
                <div class="top"> <h2><?php _e('Respond','aletheme'); ?></h2> </div>
                <form method="post" action="<?php the_permalink();?>" class="cf">
                <?php if (isset($_GET['success'])) : ?>
                    <p class="success"><?php _e('Thank you for your message!', 'aletheme')?></p>
                <?php endif; ?>
                <?php if (isset($error) && isset($error['msg'])) : ?>
                    <p class="error"><?php echo $error['msg']?></p>
                <?php endif; ?>

                    <div class="col-4">
                        <input value="<?php echo isset($_POST['contact']['name']) ? $_POST['contact']['name'] : ''?>" type="text" class="name" placeholder="<?php _e('Type your name', 'aletheme'); ?>" name="contact[name]" id="name2" tabindex="1" <?php if ($req) echo "aria-required='true'"; ?> required="required">
                    </div>
                    <div class="col-4">
                        <input value="<?php echo isset($_POST['contact']['email']) ? $_POST['contact']['email'] : ''?>" type="email" placeholder="<?php _e('Type your email', 'aletheme'); ?>" class="email" name="contact[email]" id="email2" tabindex="2" <?php if ($req) echo "aria-required='true'"; ?> required="required" email="true">
                    </div>
                    <div class="col-4">
                        <input value="<?php echo isset($_POST['contact']['site']) ? $_POST['contact']['site'] : ''?>" type="url" placeholder="<?php _e('Type your website', 'aletheme'); ?>" class="site" name="contact[url]" id="site2" tabindex="3" >
                    </div>
                    <textarea name="contact[message]" placeholder="<?php _e('Type your message', 'aletheme'); ?>" id="message2" class="message" required="required"><?php echo isset($_POST['contact']['message']) ? $_POST['contact']['message'] : ''?></textarea>
                    <div class="message-submit">
                        <input type="submit" class="submit" value="<?php _e('SUBMIT', 'aletheme'); ?>"/>
                    </div>
                    <?php wp_nonce_field() ?>
                </form>
            </div>

        </article>

    </section>

<?php get_footer(); ?>