<?php
/**
 * Template Name: Template About Us
 */
get_header(); ?>
    <!-- Content Section -->
    <section class="center-align">

        <!-- Caption -->
        <div class="title-page">
            <h2><?php wp_title("", true); ?></h2>

            <div class="page"><span class="home"></span> <?php the_breadcrumb(); ?></div>
        </div>

        <!-- -->
        <div class="dotted-line"></div>

        <!-- About Us -->
        <article class="about-us cf">
            <div class="col-6 text">
            <?php  if (have_posts()) : while (have_posts()) : the_post(); ?>
                <?php the_content();?>
            <?php endwhile;  endif; ?>
            </div>

            <div class="col-6 slider">
                <div id="about-slider">
                    <ul class="slides">
                        <?php $args = array(
                            'post_type' => 'attachment',
                            'numberposts' => -1,
                            'post_status' => null,
                            'order'				=> 'ASC',
                            'orderby'			=> 'menu_order ID',
                            'meta_query'		=> array(
                                array(
                                    'key'		=> '_ale_hide_from_gallery',
                                    'value'		=> 0,
                                    'type'		=> 'DECIMAL',
                                ),
                            ),
                            'post_parent' => $post->ID
                        );
                        $attachments = get_posts( $args );
                        if ( $attachments ) {
                            foreach ( $attachments as $attachment ) { ?>

                                <li data-thumb="<?php echo $attachment->guid; ?>">
                                    <?php echo wp_get_attachment_image( $attachment->ID, 'about-slider-thumba' ); ?>
                                </li>
                            <?php }
                        } ?>
                    </ul>
                </div>
            </div>
        </article>

        <!-- -->
        <div class="dotted-line"></div>

        <!-- Our Teachers -->
        <article class="our-teachers cf">
            <h2 class="title"><?php _e('Our Teachers','aletheme'); ?></h2>

            <div class="teachers">
                <div class="col-4">
                    <div class="back-frame">
                        <div class="image">
                            <img src="<?php if(ale_get_meta('ourteachersphoto1')) : echo ale_get_meta('ourteachersphoto1'); else : echo "http://placehold.it/281x163"; endif; ?>" alt=""/>
                            <ul>
                                <?php if(ale_get_meta('ourteachersfacebook1')) : ?><li class="facebook"><a href="<?php echo ale_get_meta('ourteachersfacebook1');?>"></a></li><?php endif; ?>
                                <?php if(ale_get_meta('ourteacherspinterest1')) : ?><li class="pinterest"><a href="<?php echo ale_get_meta('ourteacherspinterest1');?>"></a></li><?php endif; ?>
                                <?php if(ale_get_meta('ourteacherstwitter1')) : ?><li class="twitter"><a href="<?php echo ale_get_meta('ourteacherstwitter1');?>"></a></li><?php endif; ?>
                            </ul>
                        </div>

                        <!-- -->
                        <h3><?php echo ale_get_meta('ourteachersname1');?></h3>

                        <!-- -->
                        <p>
                            <?php echo ale_get_meta('ourteacherstext1');?>
                        </p>
                    </div>
                </div>
                <div class="col-4">
                    <div class="back-frame">
                        <div class="image">
                                <img src="<?php if(ale_get_meta('ourteachersphoto2')) : echo ale_get_meta('ourteachersphoto2'); else : echo "http://placehold.it/281x163"; endif; ?>" alt=""/>                            <ul>
                                <?php if(ale_get_meta('ourteachersfacebook2')) : ?><li class="facebook"><a href="<?php echo ale_get_meta('ourteachersfacebook2');?>"></a></li><?php endif; ?>
                                <?php if(ale_get_meta('ourteacherspinterest2')) : ?><li class="pinterest"><a href="<?php echo ale_get_meta('ourteacherspinterest2');?>"></a></li><?php endif; ?>
                                <?php if(ale_get_meta('ourteacherstwitter2')) : ?><li class="twitter"><a href="<?php echo ale_get_meta('ourteacherstwitter2');?>"></a></li><?php endif; ?>
                            </ul>
                        </div>

                        <!-- -->
                        <h3><?php echo ale_get_meta('ourteachersname2');?></h3>

                        <!-- -->
                        <p>
                            <?php echo ale_get_meta('ourteacherstext2');?>
                        </p>
                    </div>
                </div>
                <div class="col-4">
                    <div class="back-frame">
                        <div class="image">
                                <img src="<?php if(ale_get_meta('ourteachersphoto3')) : echo ale_get_meta('ourteachersphoto3'); else : echo "http://placehold.it/281x163"; endif; ?>" alt=""/>                            <ul>
                                <?php if(ale_get_meta('ourteachersfacebook3')) : ?><li class="facebook"><a href="<?php echo ale_get_meta('ourteachersfacebook3');?>"></a></li><?php endif; ?>
                                <?php if(ale_get_meta('ourteacherspinterest3')) : ?><li class="pinterest"><a href="<?php echo ale_get_meta('ourteacherspinterest3');?>"></a></li><?php endif; ?>
                                <?php if(ale_get_meta('ourteacherstwitter3')) : ?><li class="twitter"><a href="<?php echo ale_get_meta('ourteacherstwitter3');?>"></a></li><?php endif; ?>
                            </ul>
                        </div>

                        <!-- -->
                        <h3><?php echo ale_get_meta('ourteachersname3');?></h3>

                        <!-- -->
                        <p>
                            <?php echo ale_get_meta('ourteacherstext3');?>
                        </p>
                    </div>
                </div>
            </div>

        </article>

    </section>
<?php get_footer(); ?>