<?php get_header(); ?>
    <!-- Content Section -->
    <section class="center-align">

        <!-- Caption -->
        <div class="title-page">
            <h2><?php wp_title("", true); ?></h2>

            <div class="page"><span class="home"></span> <?php the_breadcrumb(); ?></div>
        </div>

        <!-- -->
        <div class="dotted-line"></div>

        <!-- Rooms Opened -->
        <article class="rooms-opened">
        <?php  if (have_posts()) : while (have_posts()) : the_post(); ?>
            <div id="room-slider">
                <ul class="slides">
                    <?php $args = array(
                        'post_type' => 'attachment',
                        'numberposts' => -1,
                        'post_status' => null,
                        'order'				=> 'ASC',
                        'orderby'			=> 'menu_order ID',
                        'meta_query'		=> array(
                            array(
                                'key'		=> '_ale_hide_from_gallery',
                                'value'		=> 0,
                                'type'		=> 'DECIMAL',
                            ),
                        ),
                        'post_parent' => $post->ID
                    );
                    $attachments = get_posts( $args );
                    if ( $attachments ) {
                        foreach ( $attachments as $attachment ) { ?>

                            <li data-thumb="<?php echo $attachment->guid; ?>">
                                <?php echo wp_get_attachment_image( $attachment->ID, 'rooms-slider-thumba' ); ?>
                            </li>
                        <?php }
                    } ?>
                </ul>
            </div>

                <?php the_content();?>

        <?php endwhile;  endif;?>
        </article>

        <!-- Other Rooms -->
        <article class="rooms opened">

            <h2 class="title"><?php _e('Other Rooms','aletheme'); ?></h2>

            <div class="line cf">
                <?php $posts = query_posts($query_string); if (have_posts()) : while (have_posts()) : the_post(); ?>

                <?php $prevPost = get_previous_post();
                    if($prevPost) {
                        $args = array(
                            'post_type' => 'rooms',
                            'posts_per_page' => 2,
                            'orderby' => 'rand'
                        );
                    $prevPost = get_posts($args);
                    foreach ($prevPost as $post) {
                    setup_postdata($post);
                ?>

                <div class="col-6">
                    <div class="col-6 text">
                        <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
                        <?php previous_posts_link(); ?>
                        <p>
                            <?php the_content_modified(260);?>
                        </p>
                        <a class="more" href="<?php the_permalink();?>"><?php _e('More >','aletheme'); ?></a>
                    </div>
                    <div class="col-6 img">
                        <?php if(get_the_post_thumbnail($post->ID,'rooms-thumba')) : echo get_the_post_thumbnail($post->ID,'rooms-thumba'); else : echo '<img src="http://placehold.it/237x193" alt>'; endif; ?>
                    </div>
                </div>
                <?php
                wp_reset_postdata();
                } //end foreach
                } // end if

                $nextPost = get_next_post();
                if($nextPost) {
                    $args = array(
                        'post_type' => 'rooms',
                        'posts_per_page' => 1,
                        'include' => $nextPost->ID
                    );
                $nextPost = get_posts($args);
                foreach ($nextPost as $post) {
                setup_postdata($post);
                ?>
                <div class="col-6">
                    <div class="col-6 text">
                        <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
                        <p>
                            <?php the_content_modified(260);?>
                        </p>
                        <a class="more" href="<?php the_permalink();?>"><?php _e('More >','aletheme'); ?></a>
                    </div>
                    <div class="col-6 img">
                        <?php if(get_the_post_thumbnail($post->ID,'rooms-thumba')) : echo get_the_post_thumbnail($post->ID,'rooms-thumba'); else : echo '<img src="http://placehold.it/237x193" alt>'; endif; ?>
                    </div>
                </div>
                <?php
                wp_reset_postdata();
                } //end foreach
                } // end if
                ?>


                <?php endwhile; endif; ?>
            </div>
        </article>

    </section>
<?php get_footer(); ?>