<?php get_header(); ?>

    <!-- Content Section -->
    <section class="center-align">

        <!-- Caption -->
        <div class="title-page">
            <h2><?php wp_title("", true); ?></h2>
            <div class="page"><span class="home"></span> <?php the_breadcrumb(); ?></div>
        </div>

        <!-- -->
        <div class="dotted-line"></div>

        <!-- Gallery -->
        <article class="gallery-opened">
            <?php  if (have_posts()) : while (have_posts()) : the_post(); ?>
            <!-- Slider -->
            <div id="gallery-slider">
                <ul class="slides">
                    <?php $args = array(
                        'post_type' => 'attachment',
                        'numberposts' => -1,
                        'post_status' => null,
                        'order'				=> 'ASC',
                        'orderby'			=> 'menu_order ID',
                        'meta_query'		=> array(
                            array(
                                'key'		=> '_ale_hide_from_gallery',
                                'value'		=> 0,
                                'type'		=> 'DECIMAL',
                            ),
                        ),
                        'post_parent' => $post->ID
                    );
                    $attachments = get_posts( $args );
                    if ( $attachments ) {
                        foreach ( $attachments as $attachment ) { ?>
                            <li>
                                <?php echo wp_get_attachment_image( $attachment->ID, 'gallery-slider-thumba' ); ?>
                            </li>
                        <?php }
                    } ?>
                </ul>
            </div>

            <!-- Comments -->
            <h2 class="title"><?php _e('Gallery Description','aletheme'); ?></h2>
                <?php the_content();?>
            <!-- -->
            <div class="dotted-line"></div>

            <!-- -->
            <div class="info cf">
                <h4 class="categ"><?php _e('Date:','aletheme'); ?>  <?php the_time('j M, Y');?>  / <?php
                    $current_category = wp_get_post_terms($post->ID, 'gallery-category', array("fields" => "all"));
                    foreach($current_category as $curcat){
                        echo $curcat->name.' ';
                    }
                    ?>
                </h4>
                <div class="share">
                    <h4><?php _e('Share:','aletheme'); ?></h4>
                    <ul>
                        <li class="facebook"><a href="<?php echo ale_get_share('fb'); ?>" onclick="window.open(this.href, 'Share on Facebook', 'width=600,height=300'); return false"></a></li>
                        <li class="pinterest"><a href="<?php echo ale_get_share('pin'); ?>" onclick="window.open(this.href, 'Share on Twitter', 'width=600,height=300'); return false"></a></li>
                        <li class="twitter"><a href="<?php echo ale_get_share('twi'); ?>" onclick="window.open(this.href, 'Share on Twitter', 'width=600,height=300'); return false"></a></li>
                    </ul>
                </div>
            </div>

            <?php endwhile;  endif; ?>
        </article>

    </section>

<?php get_footer(); ?>