<?php
/*
  * Template name: Home
  * */
get_header(); ?>
    <!-- Slider -->
<?php if(ale_get_option('homeslugfull')){ ?>
    <div class="center-align">
        <div id="slider">
            <ul class="slides">
                <?php
                $slider = ale_sliders_get_slider(ale_get_option('homeslugfull'));

                ?>
                <?php if($slider):?>
                    <?php foreach ($slider['slides'] as $slide) : ?>
                        <li>
                            <?php if($slide['title']): ?>
                            <div class="wood">
                                <div class="text">
                                    <span class="category"><?php echo $slide['html']; ?></span>
                                    <h2 class="caption"><?php echo $slide['title']; ?></h2>
                                    <p class="content">
                                        <?php echo $slide['description']; ?>
                                    </p>
                                    <a class="more" href="<?php echo $slide['url']; ?>"><?php _e('More >','aletheme'); ?></a>
                                </div>
                            </div>
                            <?php endif; ?>
                            <img src="<?php echo $slide['image'] ?>">
                        </li>
                    <?php endforeach; ?>
                <?php endif;?>
            </ul>
        </div>
    </div>
<?php } ?>
    <!-- Content Section -->
    <section class="center-align">

        <!-- About Us -->
        <article class="about-us-home cf">
            <?php if(ale_get_option('textblocktitle')): ?>
            <aside class="about cf">
                <?php if(ale_get_option('textblockimage')){ ?>
                    <div class="img">
                        <img src="<?php echo ale_get_option('textblockimage');?>" alt=""/>
                    </div>
                <?php } ?>
                <div class="text">
                    <h2><?php echo ale_get_option('textblocktitle');?></h2>
                    <p>
                        <?php echo ale_get_option('textblockcontent');?>
                    </p>
                    <a class="more" href="<?php echo ale_get_option('textblocklink');?>"><?php _e('More >','aletheme'); ?></a>
                </div>
            </aside>
            <?php endif; ?>
            <aside class="list">
                <ul>
                    <li class="cf">
                        <div class="icon"><img src="<?php echo ale_get_option('textblockimage1');?>" alt=""></div>
                        <a href="<?php echo ale_get_option('textlocklink1');?>" class="caption"><?php echo ale_get_option('textblocktitle1');?></a>
                        <p><?php echo ale_get_option('textblockcontent1');?></p>
                    </li>
                    <li class="cf">
                        <div class="icon"><img src="<?php echo ale_get_option('textblockimage2');?>" alt=""></div>
                        <a href="<?php echo ale_get_option('textblocklink2');?>" class="caption"><?php echo ale_get_option('textblocktitle2');?></a>
                        <p><?php echo ale_get_option('textblockcontent2');?></p>
                    </li>
                    <li class="cf">
                        <div class="icon"><img src="<?php echo ale_get_option('textblockimage3');?>" alt=""></div>
                        <a href="<?php echo ale_get_option('textblocklink3');?>" class="caption"><?php echo ale_get_option('textblocktitle3');?></a>
                        <p><?php echo ale_get_option('textblockcontent3');?></p>
                    </li>
                </ul>
            </aside>
        </article>

        <!-- Recent From Blog -->
        <article class="recent-blog-home">
            <h2 class="title"><?php _e('Recent from blog','aletheme'); ?></h2>
            <div class="items cf">
            <?php  wp_reset_query(); query_posts(array(
                'post__not_in' => get_option('sticky_posts'),
                'orderby' => 'date',
                'order' => 'DESC',
                'post_type' =>'post',
                'posts_per_page' => '4'
            ));?>
            <?php  if (have_posts()) : while (have_posts()) : the_post(); ?>
                <div class="col-3">
                    <?php if(get_the_post_thumbnail($post->ID,'post-small-thumba')) : ?>
                    <a href="<?php the_permalink();?>">
                        <?php echo get_the_post_thumbnail($post->ID,'post-small-thumba');?>
                    </a>
                    <?php else: ?>
                        <a href="<?php the_permalink(); ?>">
                            <img src="http://placehold.it/235x177" alt="">
                        </a>
                    <?php endif; ?>
                    <div class="info cf">
                        <div class="time"><?php the_time('j M Y');?></div>
                        <a href="<?php echo get_comments_link( $post->ID ); ?>" class="comments"><?php comments_number('0', '1', '%');?></a>
                    </div>
                    <div class="text">
                        <a href="<?php the_permalink();?>" class="caption"><?php the_title();?></a>
                        <p>
                            <?php the_content_modified(200);?>
                        </p>
                    </div>
                </div>
            <?php endwhile; endif; wp_reset_query(); ?>
            </div>
        </article>

        <!-- Photo Gallery -->
        <div class="center-align photo-gallery">
            <div class="top">
                <h2><?php _e('Photo Gallery','aletheme'); ?></h2>
            </div>

            <div id="photo-gallery">
                <ul class="slides">
                    <li data-thumb="<?php echo $post->guid; ?>">
                        <div class="items2">
                        <?php  wp_reset_query(); query_posts('&post_type=gallery&posts_per_page=10');?>
                        <?php $c = 0; if (have_posts()) : while (have_posts()) : the_post(); $c++ ?>

                        <?php if($c == 1) : ?>
                            <a href="<?php the_permalink();?>">
                                <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-3' ); ?>
                            </a>
                        <?php endif; ?>
                        <?php if($c == 2) : ?>
                            <a href="<?php the_permalink();?>">
                                <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-1' ); ?>
                            </a>
                        <?php endif; ?>
                        <?php if($c == 3) : ?>
                            <a href="<?php the_permalink();?>">
                                <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-2' ); ?>
                            </a>
                        <?php endif; ?>
                        <?php if($c == 4) : ?>
                            <a href="<?php the_permalink();?>">
                                <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-2' ); ?>
                            </a>
                        <?php endif; ?>
                        <?php if($c == 5): ?>
                            <a href="<?php the_permalink();?>">
                                <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-1' ); ?>
                            </a>
                        <?php endif; ?>

                        <?php endwhile;  endif; wp_reset_query();?>
                        </div>
                    </li>
                    <li data-thumb="<?php echo $post->guid; ?>">
                        <div class="items1">
                            <?php  wp_reset_query(); query_posts('&post_type=gallery&posts_per_page=10'); ?>
                            <?php $c = 0; if (have_posts()) : while (have_posts()) : the_post(); $c++ ?>

                                <?php if($c == 6) : ?>
                                    <a href="<?php the_permalink();?>">
                                        <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-3' ); ?>
                                    </a>
                                <?php endif; ?>
                                <?php if($c == 7) : ?>
                                    <a href="<?php the_permalink();?>">
                                        <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-1' ); ?>
                                    </a>
                                <?php endif; ?>
                                <?php if($c == 8) : ?>
                                    <a href="<?php the_permalink();?>">
                                        <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-2' ); ?>
                                    </a>
                                <?php endif; ?>
                                <?php if($c == 9) : ?>
                                    <a href="<?php the_permalink();?>">
                                        <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-2' ); ?>
                                    </a>
                                <?php endif; ?>
                                <?php if($c == 10): ?>
                                    <a href="<?php the_permalink();?>">
                                        <?php echo get_the_post_thumbnail($post->ID, 'gallery-gallery-1' ); ?>
                                    </a>
                                <?php endif; ?>

                            <?php endwhile;  endif; wp_reset_query();?>
                        </div>
                    </li>
                </ul>
            </div>

            <div class="back"></div>
            <div class="bottom"></div>
            <div class="anchor"></div>
        </div>
    </section>
    <?php get_footer(); ?>

