<?php
/*
  * Template name: Rooms
  * */
?>
<?php get_header(); ?>
    <!-- Content Section -->
    <section class="center-align">

        <!-- Caption -->
        <div class="title-page">
            <h2><?php _e('Our Rooms','aletheme'); ?></h2>
            <div class="page"><span class="home"></span> <?php the_breadcrumb(); ?></div>
        </div>

        <!-- -->
        <div class="dotted-line none"></div>

        <!-- Rooms -->
        <article class="rooms">
            <!-- -->
            <?php $q = new WP_Query(
                array(
                'post_type' => 'rooms',
                'posts_per_page' => -1,
                'paged' => get_query_var('paged')
                )
            );?>
            <?php if ($q -> have_posts()) : while ($q -> have_posts()) : $q -> the_post(); ?>
            <?php if( $q ->current_post%2 == 0) : ?>
            <div class="line cf">

                <div class="col-6">
                    <div class="col-6 text">
                        <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
                        <p>
                            <?php the_content_modified(250);?>
                        </p>
                        <a class="more" href="<?php the_permalink();?>"><?php _e('More >','aletheme'); ?></a>
                    </div>
                    <div class="col-6 img">
                        <?php if(get_the_post_thumbnail($post->ID,'rooms-thumba')) : echo get_the_post_thumbnail($post->ID,'rooms-thumba'); else : echo '<img src="http://placehold.it/237x193" alt>'; endif; ?>
                    </div>
                </div>
            <?php elseif( $q -> current_post%2 == 1) : ?>
                <div class="col-6">
                    <div class="col-6 text">
                        <h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
                        <p>
                            <?php the_content_modified(250);?>
                        </p>
                        <a class="more" href="<?php the_permalink();?>"><?php _e('More >','aletheme'); ?></a>
                    </div>
                    <div class="col-6 img">
                        <?php if(get_the_post_thumbnail($post->ID,'rooms-thumba')) : echo get_the_post_thumbnail($post->ID,'rooms-thumba'); else : echo '<img src="http://placehold.it/237x193" alt>'; endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php endwhile;  endif; wp_reset_query();?>
        </article>


    </section>
<?php get_footer(); ?>